/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.filter;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;

public class ConfigurableFilterConfig
implements FilterConfig {
    private Map<String, String> _parameters = new HashMap<String, String>();
    private String _name;
    private ServletContext _servletContext;

    public ConfigurableFilterConfig(FilterConfig config) {
        Enumeration parameters = config.getInitParameterNames();
        while (parameters.hasMoreElements()) {
            String name = (String)parameters.nextElement();
            this._parameters.put(name, config.getInitParameter(name));
        }
        this._name = config.getFilterName();
        this._servletContext = config.getServletContext();
    }

    public String getFilterName() {
        return this._name;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public String getInitParameter(String name) {
        return this._parameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        final LinkedList<String> keys = new LinkedList<String>(this._parameters.keySet());
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return keys.isEmpty();
            }

            public Object nextElement() {
                return keys.pop();
            }
        };
    }

    public void setParameter(String name, String value) {
        this._parameters.put(name, value);
    }

    public void setFilterName(String name) {
        this._name = name;
    }
}

