/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl.runtime;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.forms.data.modeller.service.ext.ModelReaderService;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl.AbstractBPMNFormGeneratorService;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl.GenerationContext;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl.runtime.Runtime;
import org.kie.workbench.common.forms.jbpm.service.bpmn.util.BPMNVariableUtils;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.model.FormModel;
import org.kie.workbench.common.forms.service.shared.FieldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Runtime
@Dependent
public class BPMNRuntimeFormGeneratorService
extends AbstractBPMNFormGeneratorService<ClassLoader> {
    private static final Logger logger = LoggerFactory.getLogger(BPMNRuntimeFormGeneratorService.class);

    @Inject
    public BPMNRuntimeFormGeneratorService(ModelReaderService<ClassLoader> modelReaderService, FieldManager fieldManager) {
        super(modelReaderService, fieldManager);
    }

    @Override
    protected FormDefinition createRootFormDefinition(GenerationContext<ClassLoader> context) {
        FormDefinition form = new FormDefinition((FormModel)context.getFormModel());
        form.setId(context.getFormModel().getFormName());
        form.setName(context.getFormModel().getFormName());
        context.getFormModel().getProperties().forEach(property -> {
            if (!BPMNVariableUtils.isValidInputName((String)property.getName())) {
                return;
            }
            FieldDefinition field = this.fieldManager.getDefinitionByModelProperty(property);
            if (field != null) {
                form.getFields().add(field);
            }
        });
        return form;
    }

    @Override
    protected boolean supportsEmptyNestedForms() {
        return false;
    }

    @Override
    protected void log(String message, Exception ex) {
        logger.warn(message, (Throwable)ex);
    }
}

