/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.AbstractFieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.FieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.FieldValueMarshallerRegistry;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.models.ModelMarshaller;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContext;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.multipleSubform.definition.MultipleSubFormFieldDefinition;
import org.kie.workbench.common.forms.model.FormDefinition;

@Dependent
public class MultipleSubFormFieldValueMarshaller
extends AbstractFieldValueMarshaller<List<Object>, List<Map<String, Object>>, MultipleSubFormFieldDefinition> {
    private FieldValueMarshallerRegistry registry;

    @Inject
    public void setRegistry(FieldValueMarshallerRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void init(List<Object> originalValue, MultipleSubFormFieldDefinition fieldDefinition, FormDefinition currentForm, BackendFormRenderingContext currentContext) {
        super.init(originalValue, fieldDefinition, currentForm, currentContext);
        if (originalValue == null) {
            this.originalValue = new ArrayList();
        }
    }

    @Override
    public List<Map<String, Object>> toFlatValue() {
        FormDefinition nestedForm = (FormDefinition)this.context.getRenderingContext().getAvailableForms().get(((MultipleSubFormFieldDefinition)this.fieldDefinition).getCreationForm());
        return ((List)this.originalValue).stream().map(value -> new ModelMarshaller(this.registry, value, nestedForm, this.context)).map(this::toFlatValue).collect(Collectors.toList());
    }

    private Map<String, Object> toFlatValue(ModelMarshaller modelMarshaller) {
        Map<String, Object> formValue = modelMarshaller.toFlatValue();
        formValue.put("__FormEngine-ObjectIndex", ((List)this.originalValue).indexOf(modelMarshaller.getModel()));
        formValue.put("__FormEngine-EditedObject", Boolean.FALSE);
        return formValue;
    }

    @Override
    public List<Object> toRawValue(List<Map<String, Object>> flatValues) {
        ArrayList<Object> result = new ArrayList<Object>();
        FormDefinition creationForm = (FormDefinition)this.context.getRenderingContext().getAvailableForms().get(((MultipleSubFormFieldDefinition)this.fieldDefinition).getCreationForm());
        FormDefinition editionForm = (FormDefinition)this.context.getRenderingContext().getAvailableForms().get(((MultipleSubFormFieldDefinition)this.fieldDefinition).getEditionForm());
        flatValues.stream().forEach(flatValue -> {
            boolean edited = Boolean.TRUE.equals(flatValue.get("__FormEngine-EditedObject"));
            if (flatValue.get("__FormEngine-ObjectIndex") != null) {
                int originalPosition = (Integer)flatValue.get("__FormEngine-ObjectIndex");
                if (originalPosition < ((List)this.originalValue).size()) {
                    Object value = ((List)this.originalValue).get(originalPosition);
                    if (edited) {
                        ModelMarshaller marshaller = new ModelMarshaller(this.registry, value, editionForm, this.context);
                        value = marshaller.toRawValue((Map<String, Object>)flatValue);
                    }
                    result.add(value);
                }
            } else {
                ModelMarshaller marshaller = new ModelMarshaller(this.registry, null, creationForm, this.context);
                Object value = marshaller.toRawValue((Map<String, Object>)flatValue);
                if (edited && !editionForm.equals((Object)creationForm)) {
                    marshaller = new ModelMarshaller(this.registry, value, editionForm, this.context);
                    value = marshaller.toRawValue((Map<String, Object>)flatValue);
                }
                result.add(value);
            }
        });
        return result;
    }

    @Override
    public Class<MultipleSubFormFieldDefinition> getSupportedField() {
        return MultipleSubFormFieldDefinition.class;
    }

    @Override
    public Supplier<FieldValueMarshaller<List<Object>, List<Map<String, Object>>, MultipleSubFormFieldDefinition>> newInstanceSupplier() {
        return () -> {
            MultipleSubFormFieldValueMarshaller marshaller = new MultipleSubFormFieldValueMarshaller();
            marshaller.setRegistry(this.registry);
            return marshaller;
        };
    }
}

