/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.services.backend.serialization.impl;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldSerializer
implements JsonSerializer<FieldDefinition>,
JsonDeserializer<FieldDefinition> {
    private Logger log = LoggerFactory.getLogger(FieldSerializer.class);

    public JsonElement serialize(FieldDefinition field, Type type, JsonSerializationContext context) {
        JsonElement serializedField = context.serialize((Object)field, field.getClass());
        serializedField.getAsJsonObject().addProperty("code", field.getFieldType().getTypeName());
        serializedField.getAsJsonObject().addProperty("serializedFieldClassName", field.getClass().getName());
        return serializedField;
    }

    public FieldDefinition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonField = json.getAsJsonObject();
        JsonElement jsonClassName = jsonField.get("serializedFieldClassName");
        if (jsonClassName != null && !StringUtils.isEmpty((CharSequence)jsonClassName.getAsString())) {
            try {
                return (FieldDefinition)context.deserialize(json, Class.forName(jsonClassName.getAsString()));
            }
            catch (Exception ex) {
                this.log.error("Error deserializing field", (Throwable)ex);
            }
        }
        return null;
    }
}

