/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.editor.backend.service.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.forms.dynamic.service.shared.RenderMode;
import org.kie.workbench.common.forms.editor.model.FormModelSynchronizationResult;
import org.kie.workbench.common.forms.editor.model.FormModelerContent;
import org.kie.workbench.common.forms.editor.model.FormModelerContentError;
import org.kie.workbench.common.forms.editor.service.backend.FormModelHandler;
import org.kie.workbench.common.forms.editor.service.backend.FormModelHandlerManager;
import org.kie.workbench.common.forms.editor.service.backend.SourceFormModelNotFoundException;
import org.kie.workbench.common.forms.editor.service.shared.FormEditorRenderingContext;
import org.kie.workbench.common.forms.editor.service.shared.FormEditorService;
import org.kie.workbench.common.forms.editor.service.shared.ModuleFormFinderService;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.model.FormModel;
import org.kie.workbench.common.forms.service.shared.FieldManager;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.kie.workbench.common.forms.services.backend.util.UIDGenerator;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class FormEditorServiceImpl
extends KieService<FormModelerContent>
implements FormEditorService {
    public static final String SHORT_KEY = "FormEditorService.shortKey";
    public static final String LONG_KEY = "FormEditorService.longKey";
    private FieldManager fieldManager;
    private FormModelHandlerManager modelHandlerManager;
    private FormDefinitionSerializer formDefinitionSerializer;
    private ModuleFormFinderService moduleFormFinderService;
    private DeleteService deleteService;
    private RenameService renameService;
    private CopyService copyService;
    private Logger log = LoggerFactory.getLogger(FormEditorServiceImpl.class);
    private IOService ioService;
    private SessionInfo sessionInfo;
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    private CommentedOptionFactory commentedOptionFactory;

    @Inject
    public FormEditorServiceImpl(@Named(value="ioStrategy") IOService ioService, SessionInfo sessionInfo, Event<ResourceOpenedEvent> resourceOpenedEvent, FieldManager fieldManager, FormModelHandlerManager modelHandlerManager, KieModuleService moduleService, FormDefinitionSerializer formDefinitionSerializer, ModuleFormFinderService moduleFormFinderService, DeleteService deleteService, CommentedOptionFactory commentedOptionFactory, RenameService renameService, CopyService copyService) {
        this.ioService = ioService;
        this.sessionInfo = sessionInfo;
        this.resourceOpenedEvent = resourceOpenedEvent;
        this.fieldManager = fieldManager;
        this.modelHandlerManager = modelHandlerManager;
        this.moduleService = moduleService;
        this.formDefinitionSerializer = formDefinitionSerializer;
        this.moduleFormFinderService = moduleFormFinderService;
        this.commentedOptionFactory = commentedOptionFactory;
        this.deleteService = deleteService;
        this.renameService = renameService;
        this.copyService = copyService;
    }

    public FormModelerContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (FormModelerContent)super.loadContent(path);
    }

    public org.uberfire.backend.vfs.Path createForm(org.uberfire.backend.vfs.Path path, String formName, FormModel formModel) {
        Path kiePath = Paths.convert((org.uberfire.backend.vfs.Path)path).resolve(formName);
        try {
            if (this.ioService.exists(kiePath)) {
                throw new FileAlreadyExistsException(kiePath.toString());
            }
            FormDefinition form = new FormDefinition(formModel);
            form.setId(UIDGenerator.generateUID());
            form.setName(formName.substring(0, formName.lastIndexOf(".")));
            form.setLayoutTemplate(new LayoutTemplate());
            this.ioService.write(kiePath, this.formDefinitionSerializer.serialize(form), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption("")});
            return Paths.convert((Path)kiePath);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            KieModule module = (KieModule)this.moduleService.resolveModule(path);
            if (module == null) {
                logger.warn("Form : " + path.toURI() + " does not belong to a valid module");
                return;
            }
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            logger.error("Form: " + path.toURI() + " couldn't be deleted due to the following error. ", (Throwable)e);
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, FormModelerContent content, Metadata metadata, String comment) {
        this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), this.formDefinitionSerializer.serialize(content.getDefinition()), this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
        return path;
    }

    public FormModelerContent rename(org.uberfire.backend.vfs.Path path, String newFileName, String commitMessage, boolean saveBeforeRenaming, FormModelerContent content, Metadata metadata) {
        if (saveBeforeRenaming) {
            this.save(path, content, metadata, commitMessage);
        }
        this.renameService.rename(path, newFileName, commitMessage);
        return content;
    }

    public void copy(org.uberfire.backend.vfs.Path path, String newFileName, String commitMessage, boolean saveBeforeCopying, FormModelerContent content, Metadata metadata) {
        if (saveBeforeCopying) {
            this.save(path, content, metadata, commitMessage);
        }
        this.copyService.copy(path, newFileName, commitMessage);
    }

    protected FormModelerContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        FormModelerContent formModelConent = new FormModelerContent();
        try {
            Path kiePath = Paths.convert((org.uberfire.backend.vfs.Path)path);
            FormDefinition form = this.findForm(kiePath);
            formModelConent.setDefinition(form);
            formModelConent.setPath(path);
            formModelConent.setOverview(overview);
            FormEditorRenderingContext context = this.createRenderingContext(form, path);
            formModelConent.setRenderingContext(context);
            if (Optional.ofNullable(form.getModel()).isPresent()) {
                FormModel formModel = form.getModel();
                Optional<FormModelHandler> modelHandlerOptional = this.getHandlerForForm(form);
                if (modelHandlerOptional.isPresent()) {
                    try {
                        FormModelHandler formModelHandler = modelHandlerOptional.get();
                        formModelHandler.init(formModel, path);
                        formModelHandler.checkSourceModel();
                        FormModelSynchronizationResult synchronizationResult = formModelHandler.synchronizeFormModel();
                        formModel.getProperties().forEach(property -> {
                            Optional<FieldDefinition> fieldOptional = Optional.ofNullable(form.getFieldByBinding(property.getName()));
                            if (!fieldOptional.isPresent()) {
                                synchronizationResult.resolveConflict(property.getName());
                            }
                        });
                        formModelConent.setSynchronizationResult(synchronizationResult);
                    }
                    catch (SourceFormModelNotFoundException ex) {
                        formModelConent.setError(new FormModelerContentError(ex.getShortKey(), ex.getShortKeyParams(), ex.getLongKey(), ex.getLongKeyParams(), ex.getModelSourceKey()));
                    }
                }
            }
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            formModelConent.setError(new FormModelerContentError(SHORT_KEY, null, LONG_KEY, new String[]{writer.toString()}, null));
            this.log.warn("Error loading form " + path.toURI(), (Throwable)e);
        }
        this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, this.sessionInfo));
        return formModelConent;
    }

    protected FormEditorRenderingContext createRenderingContext(FormDefinition form, org.uberfire.backend.vfs.Path formPath) {
        FormEditorRenderingContext context = new FormEditorRenderingContext("edition", formPath);
        context.setRootForm(form);
        context.setRenderMode(RenderMode.READ_ONLY_MODE);
        List allForms = this.moduleFormFinderService.findAllForms(formPath);
        for (FormDefinition vfsForm : allForms) {
            if (vfsForm.getId().equals(form.getId())) continue;
            context.getAvailableForms().put(vfsForm.getId(), vfsForm);
        }
        return context;
    }

    protected FormDefinition findForm(Path path) throws Exception {
        String template = this.ioService.readAllString(path).trim();
        FormDefinition form = this.formDefinitionSerializer.deserialize(template);
        if (form == null) {
            form = new FormDefinition();
            form.setId(UIDGenerator.generateUID());
        }
        return form;
    }

    protected Optional<FormModelHandler> getHandlerForForm(FormDefinition form) {
        return Optional.ofNullable(this.modelHandlerManager.getFormModelHandler(form.getModel().getClass()));
    }
}

