/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.Collection;
import java.util.function.Function;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.exception.BadCommandArgumentsException;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.AbstractGraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommand;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.index.MutableIndex;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.context.GraphEvaluationContext;
import org.kie.workbench.common.stunner.core.rule.context.impl.RuleEvaluationContextBuilder;

public abstract class AbstractGraphCommand
implements GraphCommand {
    protected abstract CommandResult<RuleViolation> check(GraphCommandExecutionContext var1);

    public CommandResult<RuleViolation> allow(GraphCommandExecutionContext context) {
        return this.check(context);
    }

    protected Collection<RuleViolation> evaluate(GraphCommandExecutionContext context, Function<RuleEvaluationContextBuilder.GraphContextBuilder, GraphEvaluationContext> contextBuilder) {
        return (Collection)((AbstractGraphCommandExecutionContext)context).evaluate(contextBuilder).violations();
    }

    protected MutableIndex<Node, Edge> getMutableIndex(GraphCommandExecutionContext context) {
        return (MutableIndex)context.getGraphIndex();
    }

    protected Graph<?, Node> getGraph(GraphCommandExecutionContext context) {
        return context.getGraphIndex().getGraph();
    }

    protected Node<?, Edge> getNode(GraphCommandExecutionContext context, String uuid) {
        return context.getGraphIndex().getNode(uuid);
    }

    protected Edge<? extends View, Node> getViewEdge(GraphCommandExecutionContext context, String uuid) {
        return context.getGraphIndex().getEdge(uuid);
    }

    protected <C> Node<C, Edge> getNodeNotNull(GraphCommandExecutionContext context, String uuid) {
        Node<?, Edge> node = this.getNode(context, uuid);
        if (null == node) {
            throw new BadCommandArgumentsException((Command)this, (Object)uuid, "Node not found for [" + uuid + "].");
        }
        return node;
    }

    protected <C> Element<C> getElementNotNull(GraphCommandExecutionContext context, String uuid) {
        Element element = context.getGraphIndex().get(uuid);
        if (null == element) {
            throw new BadCommandArgumentsException((Command)this, (Object)uuid, "Element not found for [" + uuid + "].");
        }
        return element;
    }
}

