/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCompositeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.RegisterNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SafeDeleteNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SetChildrenCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.UpdateElementPositionCommand;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.context.CardinalityContext;

@Portable
public class AddChildNodeCommand
extends AbstractGraphCompositeCommand {
    private final String parentUUID;
    private final Node candidate;
    private final Point2D location;
    private transient Node<?, Edge> parent;

    public AddChildNodeCommand(@MapsTo(value="parentUUID") String parentUUID, @MapsTo(value="candidate") Node candidate, @MapsTo(value="location") Point2D location) {
        this.parentUUID = (String)PortablePreconditions.checkNotNull((String)"parentUUID", (Object)parentUUID);
        this.candidate = (Node)PortablePreconditions.checkNotNull((String)"candidate", (Object)candidate);
        this.location = location;
    }

    public AddChildNodeCommand(Node<?, Edge> parent, Node candidate, Point2D location) {
        this(parent.getUUID(), candidate, location);
        this.parent = parent;
    }

    public AddChildNodeCommand(Node<?, Edge> parent, Node candidate) {
        this(parent, candidate, null);
    }

    protected AddChildNodeCommand initialize(GraphCommandExecutionContext context) {
        super.initialize(context);
        Node<?, Edge> parent = this.getParent(context);
        this.addCommand(this.getRegisterNodeCommand(this.candidate));
        this.addCommand(this.getSetChildNodeCommand(parent, this.candidate));
        if (null != this.location) {
            this.addCommand(this.getUpdateElementPositionCommand(this.candidate, this.location));
        }
        return this;
    }

    protected RegisterNodeCommand getRegisterNodeCommand(Node candidate) {
        return new RegisterNodeCommand(candidate);
    }

    protected SetChildrenCommand getSetChildNodeCommand(Node<?, Edge> parent, Node candidate) {
        return new SetChildrenCommand(parent, candidate);
    }

    protected UpdateElementPositionCommand getUpdateElementPositionCommand(Node candidate, Point2D location) {
        return new UpdateElementPositionCommand(candidate, location);
    }

    @Override
    public CommandResult<RuleViolation> allow(GraphCommandExecutionContext context) {
        this.ensureInitialized(context);
        Node<?, Edge> parent = this.getParent(context);
        Collection<RuleViolation> containmentRuleViolations = this.evaluate(context, contextBuilder -> contextBuilder.containment((Element<? extends Definition<?>>)parent, (Node<? extends Definition<?>, ? extends Edge>)this.candidate));
        Collection<RuleViolation> cardinalityRuleViolations = this.evaluate(context, contextBuilder -> contextBuilder.cardinality(Collections.singleton(this.candidate), CardinalityContext.Operation.ADD));
        LinkedList<RuleViolation> violations = new LinkedList<RuleViolation>();
        violations.addAll(containmentRuleViolations);
        violations.addAll(cardinalityRuleViolations);
        return new GraphCommandResultBuilder((Collection<RuleViolation>)violations).build();
    }

    @Override
    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        return new SafeDeleteNodeCommand(this.getCandidate()).execute(context);
    }

    protected Node<?, Edge> getParent(GraphCommandExecutionContext context) {
        if (null == this.parent) {
            this.parent = this.checkNodeNotNull(context, this.parentUUID);
        }
        return this.parent;
    }

    public Node<?, Edge> getParent() {
        return this.parent;
    }

    public Node getCandidate() {
        return this.candidate;
    }

    public Point2D getLocation() {
        return this.location;
    }

    @Override
    public String toString() {
        return "AddChildNodeCommand [parent=" + this.parentUUID + ", candidate=" + this.candidate.getUUID() + "]";
    }

    @Override
    protected boolean delegateRulesContextToChildren() {
        return false;
    }
}

