/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.List;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SetParentNodeCommand;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Parent;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

@Portable
public final class RemoveParentCommand
extends AbstractGraphCommand {
    private final String parentUUID;
    private final String candidateUUID;
    private transient Node<?, Edge> parent;
    private transient Node<?, Edge> candidate;

    public RemoveParentCommand(@MapsTo(value="parentUUID") String parentUUID, @MapsTo(value="candidateUUID") String candidateUUID) {
        this.parentUUID = (String)PortablePreconditions.checkNotNull((String)"parentUUID", (Object)parentUUID);
        this.candidateUUID = (String)PortablePreconditions.checkNotNull((String)"candidateUUID", (Object)candidateUUID);
    }

    public RemoveParentCommand(Node<?, Edge> parent, Node<?, Edge> candidate) {
        this(parent.getUUID(), candidate.getUUID());
        this.parent = parent;
        this.candidate = candidate;
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        Node<?, Edge> candidate;
        Node<?, Edge> parent;
        Edge<Parent, Node> edge;
        CommandResult<RuleViolation> results = this.allow(context);
        if (!results.getType().equals((Object)CommandResult.Type.ERROR) && null != (edge = this.getEdgeForTarget(parent = this.getParent(context), candidate = this.getCandidate(context)))) {
            edge.setSourceNode(null);
            edge.setTargetNode(null);
            parent.getInEdges().remove(edge);
            candidate.getOutEdges().remove(edge);
            this.getMutableIndex(context).removeEdge(edge);
        }
        return results;
    }

    private Edge<Parent, Node> getEdgeForTarget(Node<?, Edge> parent, Node<?, Edge> candidate) {
        List outEdges = parent.getInEdges();
        if (null != outEdges && !outEdges.isEmpty()) {
            for (Edge outEdge : outEdges) {
                Node source;
                if (!(outEdge.getContent() instanceof Parent) || null == (source = outEdge.getSourceNode()) || !source.equals(candidate)) continue;
                return outEdge;
            }
        }
        return null;
    }

    @Override
    protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
        this.getParent(context);
        this.getCandidate(context);
        return GraphCommandResultBuilder.SUCCESS;
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        Node<?, Edge> parent = this.getParent(context);
        Node<?, Edge> candidate = this.getCandidate(context);
        SetParentNodeCommand undoCommand = new SetParentNodeCommand(parent, candidate);
        return undoCommand.execute(context);
    }

    private Node<?, Edge> getParent(GraphCommandExecutionContext context) {
        if (null == this.parent) {
            this.parent = this.getNodeNotNull(context, this.parentUUID);
        }
        return this.parent;
    }

    private Node<?, Edge> getCandidate(GraphCommandExecutionContext context) {
        if (null == this.candidate) {
            this.candidate = this.getNodeNotNull(context, this.candidateUUID);
        }
        return this.candidate;
    }

    public String toString() {
        return "DeleteParentEdgeCommand [parent=" + this.parentUUID + ", candidate=" + this.candidateUUID + "]";
    }
}

