/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.Collection;
import java.util.Optional;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.context.CardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.EdgeCardinalityContext;

@Portable
public final class SetConnectionSourceNodeCommand
extends AbstractGraphCommand {
    private final String sourceNodeUUID;
    private final String edgeUUID;
    private final Connection connection;
    Connection lastConnection;
    private String lastSourceNodeUUID;
    private transient Edge<? extends View, Node> edge;
    private transient Node<? extends View<?>, Edge> targetNode;
    private transient Node<? extends View<?>, Edge> sourceNode;

    public SetConnectionSourceNodeCommand(@MapsTo(value="sourceNodeUUID") String sourceNodeUUID, @MapsTo(value="edgeUUID") String edgeUUID, @MapsTo(value="magnet") Connection connection) {
        this.edgeUUID = (String)PortablePreconditions.checkNotNull((String)"edgeUUID", (Object)edgeUUID);
        this.sourceNodeUUID = sourceNodeUUID;
        this.connection = connection;
        this.lastSourceNodeUUID = null;
        this.lastConnection = null;
    }

    public SetConnectionSourceNodeCommand(Node<? extends View<?>, Edge> sourceNode, Edge<? extends View, Node> edge, Connection connection) {
        this(null != sourceNode ? sourceNode.getUUID() : null, edge.getUUID(), connection);
        this.sourceNode = sourceNode;
        this.edge = edge;
        this.targetNode = edge.getTargetNode();
    }

    public SetConnectionSourceNodeCommand(Node<? extends View<?>, Edge> sourceNode, Edge<? extends View, Node> edge) {
        this(sourceNode, edge, null);
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        CommandResult<RuleViolation> results = this.allow(context);
        if (!results.getType().equals((Object)CommandResult.Type.ERROR)) {
            Edge<? extends View, Node> edge = this.getEdge(context);
            Node<? extends View<?>, Edge> sourceNode = this.getSourceNode(context);
            Node lastSourceNode = edge.getSourceNode();
            if (null != lastSourceNode) {
                this.lastSourceNodeUUID = lastSourceNode.getUUID();
                lastSourceNode.getOutEdges().remove(edge);
            }
            if (null != sourceNode) {
                sourceNode.getOutEdges().add(edge);
            }
            edge.setSourceNode(sourceNode);
            ViewConnector connectionContent = (ViewConnector)edge.getContent();
            this.lastConnection = connectionContent.getSourceConnection().orElse(null);
            connectionContent.setSourceConnection(this.connection);
        }
        return results;
    }

    @Override
    protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
        GraphCommandResultBuilder resultBuilder = new GraphCommandResultBuilder();
        Node<? extends View<?>, Edge> sourceNode = this.getSourceNode(context);
        Edge<? extends View, Node> edge = this.getEdge(context);
        Node lastSourceNode = edge.getSourceNode();
        if (null == lastSourceNode && null != sourceNode || null != lastSourceNode && !lastSourceNode.equals(sourceNode)) {
            Collection<RuleViolation> cardinalityRuleViolations;
            Collection<RuleViolation> connectionRuleViolations = this.evaluate(context, contextBuilder -> contextBuilder.connection(edge, Optional.ofNullable(sourceNode), Optional.ofNullable(this.targetNode)));
            resultBuilder.addViolations(connectionRuleViolations);
            Node currentSource = edge.getSourceNode();
            if (null != currentSource) {
                cardinalityRuleViolations = this.evaluate(context, contextBuilder -> contextBuilder.edgeCardinality((Element<? extends View<?>>)currentSource, (Edge<? extends View<?>, Node>)edge, EdgeCardinalityContext.Direction.OUTGOING, Optional.of(CardinalityContext.Operation.DELETE)));
                resultBuilder.addViolations(cardinalityRuleViolations);
            }
            if (null != sourceNode) {
                cardinalityRuleViolations = this.evaluate(context, contextBuilder -> contextBuilder.edgeCardinality((Element<? extends View<?>>)sourceNode, (Edge<? extends View<?>, Node>)edge, EdgeCardinalityContext.Direction.OUTGOING, Optional.of(CardinalityContext.Operation.ADD)));
                resultBuilder.addViolations(cardinalityRuleViolations);
            }
        }
        return resultBuilder.build();
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        SetConnectionSourceNodeCommand undoCommand = new SetConnectionSourceNodeCommand(this.getNode(context, this.lastSourceNodeUUID), this.getEdge(context), this.lastConnection);
        return undoCommand.execute(context);
    }

    public Node<? extends View<?>, Edge> getTargetNode(GraphCommandExecutionContext context) {
        if (null == this.targetNode) {
            this.targetNode = this.getEdge(context).getTargetNode();
        }
        return this.targetNode;
    }

    public Node<? extends View<?>, Edge> getSourceNode(GraphCommandExecutionContext context) {
        if (null == this.sourceNode) {
            this.sourceNode = this.getNode(context, this.sourceNodeUUID);
        }
        return this.sourceNode;
    }

    public Edge<? extends View, Node> getEdge(GraphCommandExecutionContext context) {
        if (null == this.edge) {
            this.edge = this.getViewEdge(context, this.edgeUUID);
        }
        return this.edge;
    }

    public Node<? extends View<?>, Edge> getSourceNode() {
        return this.sourceNode;
    }

    public Edge<? extends View, Node> getEdge() {
        return this.edge;
    }

    public Node<? extends View<?>, Edge> getTargetNode() {
        return this.targetNode;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String toString() {
        return "SetConnectionSourceNodeCommand [edge=" + this.edgeUUID + ", candidate=" + (null != this.sourceNodeUUID ? this.sourceNodeUUID : "null") + ", magnet=" + this.connection + "]";
    }
}

