/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractControlPointCommand;
import org.kie.workbench.common.stunner.core.graph.content.HasControlPoints;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.util.ControlPointValidations;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

@Portable
public class UpdateControlPointPositionCommand
extends AbstractControlPointCommand {
    private final ControlPoint[] controlPoints;
    private transient ControlPoint[] oldControlPoints;

    public UpdateControlPointPositionCommand(@MapsTo(value="edgeUUID") String edgeUUID, @MapsTo(value="controlPoints") ControlPoint[] controlPoints) {
        super(edgeUUID);
        this.controlPoints = (ControlPoint[])PortablePreconditions.checkNotNull((String)"controlPoints", (Object)controlPoints);
    }

    @Override
    protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
        ControlPointValidations.checkUpdateControlPoint(this.getEdgeControlPoints(context).getControlPoints(), this.controlPoints);
        return GraphCommandResultBuilder.SUCCESS;
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        HasControlPoints hasControlPoints = this.getEdgeControlPoints(context);
        this.oldControlPoints = hasControlPoints.getControlPoints();
        hasControlPoints.setControlPoints(this.controlPoints);
        return GraphCommandResultBuilder.SUCCESS;
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        return new UpdateControlPointPositionCommand(this.getEdgeUUID(), this.oldControlPoints).execute(context);
    }
}

