/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.adapter.PropertyAdapter;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.registry.definition.AdapterRegistry;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

@Portable
public final class UpdateDomainObjectPropertyValueCommand
extends AbstractGraphCommand {
    private final DomainObject domainObject;
    private final String propertyId;
    private final Object value;
    private Object oldValue;

    public UpdateDomainObjectPropertyValueCommand(@MapsTo(value="domainObject") DomainObject domainObject, @MapsTo(value="propertyId") String propertyId, @MapsTo(value="value") Object value) {
        this.domainObject = (DomainObject)PortablePreconditions.checkNotNull((String)"domainObject", (Object)domainObject);
        this.propertyId = (String)PortablePreconditions.checkNotNull((String)"propertyId", (Object)propertyId);
        this.value = value;
    }

    @Override
    protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
        return GraphCommandResultBuilder.SUCCESS;
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        DefinitionManager definitionManager = context.getDefinitionManager();
        Object p = GraphUtils.getPropertyByField(definitionManager, this.domainObject, this.propertyId);
        AdapterManager adapterManager = definitionManager.adapters();
        AdapterRegistry adapterRegistry = adapterManager.registry();
        PropertyAdapter adapter = adapterRegistry.getPropertyAdapter(p.getClass());
        this.oldValue = adapter.getValue(p);
        adapter.setValue(p, this.value);
        return GraphCommandResultBuilder.SUCCESS;
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        UpdateDomainObjectPropertyValueCommand undoCommand = new UpdateDomainObjectPropertyValueCommand(this.domainObject, this.propertyId, this.oldValue);
        return undoCommand.execute(context);
    }

    public String toString() {
        return "UpdateDomainObjectPropertyValueCommand [domainObject=" + this.domainObject + ", property=" + this.propertyId + ", value=" + this.value + "]";
    }
}

