/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.traverse.content;

import java.util.Objects;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.AbstractContentTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ContentTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ViewTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;

@Dependent
public final class ViewTraverseProcessorImpl
extends AbstractContentTraverseProcessor<View<?>, Node<View, Edge>, Edge<View<?>, Node>, ContentTraverseCallback<View<?>, Node<View, Edge>, Edge<View<?>, Node>>>
implements ViewTraverseProcessor {
    @Inject
    public ViewTraverseProcessorImpl(TreeWalkTraverseProcessor treeWalkTraverseProcessor) {
        super(treeWalkTraverseProcessor);
        treeWalkTraverseProcessor.useStartNodePredicate(this.newStartNodePredicate());
    }

    protected Predicate<Node<?, Edge>> newStartNodePredicate() {
        return node -> !node.getInEdges().stream().filter(ViewTraverseProcessorImpl::isViewEdge).filter(ViewTraverseProcessorImpl::isNotCyclicEdge).findAny().isPresent();
    }

    @Override
    protected boolean accepts(Edge edge) {
        return ViewTraverseProcessorImpl.isViewEdge(edge);
    }

    private static boolean isViewEdge(Edge edge) {
        return edge.getContent() instanceof View;
    }

    private static boolean isNotCyclicEdge(Edge edge) {
        String sourceId = edge.getSourceNode() != null ? edge.getSourceNode().getUUID() : null;
        String targetId = edge.getTargetNode() != null ? edge.getTargetNode().getUUID() : null;
        return !Objects.equals(sourceId, targetId);
    }
}

