/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.i18n;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;
import org.kie.workbench.common.stunner.core.validation.DomainViolation;
import org.kie.workbench.common.stunner.core.validation.ModelBeanViolation;

public class CoreTranslationMessages {
    private static final String SEP = ".";
    private static final String CORE_PREF = "org.kie.workbench.common.stunner.core.";
    private static final String COMMAND_PREF = "org.kie.workbench.common.stunner.core.command.";
    private static final String RULE_PREF = "org.kie.workbench.common.stunner.core.rule.";
    private static final String CLIENT_PREF = "org.kie.workbench.common.stunner.core.client.";
    public static final String ERROR = "org.kie.workbench.common.stunner.core.error";
    public static final String WARNING = "org.kie.workbench.common.stunner.core.warn";
    public static final String INFO = "org.kie.workbench.common.stunner.core.info";
    public static final String REASON = "org.kie.workbench.common.stunner.core.reason";
    public static final String DELETE = "org.kie.workbench.common.stunner.core.delete";
    public static final String EDIT = "org.kie.workbench.common.stunner.core.edit";
    public static final String PRINT = "org.kie.workbench.common.stunner.core.print";
    public static final String RESET = "org.kie.workbench.common.stunner.core.reset";
    public static final String INCREASE = "org.kie.workbench.common.stunner.core.increase";
    public static final String DECREASE = "org.kie.workbench.common.stunner.core.decrease";
    public static final String FIT = "org.kie.workbench.common.stunner.core.fit";
    public static final String ARE_YOU_SURE = "org.kie.workbench.common.stunner.core.areYouSure";
    public static final String COMMAND_SUCCESS = "org.kie.workbench.common.stunner.core.command.success";
    public static final String COMMAND_FAILED = "org.kie.workbench.common.stunner.core.command.fail";
    public static final String VALIDATION_SUCCESS = "org.kie.workbench.common.stunner.core.rule.success";
    public static final String VALIDATION_PROPERTY = "org.kie.workbench.common.stunner.core.rule.property";
    public static final String ELEMENT = "org.kie.workbench.common.stunner.core.rule.element";
    public static final String VALIDATION_FAILED = "org.kie.workbench.common.stunner.core.rule.fail";
    public static final String MEDIATOR_PREVIEW = "org.kie.workbench.common.stunner.core.client.mediator.zoomArea";
    public static final String DIAGRAM_LOAD_FAIL_UNSUPPORTED_ELEMENTS = "org.kie.workbench.common.stunner.core.client.diagram.load.fail.unsupported";
    public static final String DIAGRAM_AUTOMATIC_LAYOUT_PERFORMED = "org.kie.workbench.common.stunner.core.client.diagram.automatic.layout.performed";
    public static final String COPY_SELECTION = "org.kie.workbench.common.stunner.core.client.toolbox.CopySelection";
    public static final String CUT_SELECTION = "org.kie.workbench.common.stunner.core.client.toolbox.CutSelection";
    public static final String PASTE_SELECTION = "org.kie.workbench.common.stunner.core.client.toolbox.PasteSelection";
    public static final String VISIT_GRAPH = "org.kie.workbench.common.stunner.core.client.toolbox.VisitGraph";
    public static final String VALIDATE = "org.kie.workbench.common.stunner.core.client.toolbox.Validate";
    public static final String UNDO = "org.kie.workbench.common.stunner.core.client.toolbox.Undo";
    public static final String SWITCH_GRID = "org.kie.workbench.common.stunner.core.client.toolbox.SwitchGrid";
    public static final String REDO = "org.kie.workbench.common.stunner.core.client.toolbox.Redo";
    public static final String SAVE = "org.kie.workbench.common.stunner.core.client.toolbox.Save";
    public static final String EXPORT_PNG = "org.kie.workbench.common.stunner.core.client.toolbox.ExportPNG";
    public static final String EXPORT_PDF = "org.kie.workbench.common.stunner.core.client.toolbox.ExportPDF";
    public static final String EXPORT_JPG = "org.kie.workbench.common.stunner.core.client.toolbox.ExportJPG";
    public static final String EXPORT_SVG = "org.kie.workbench.common.stunner.core.client.toolbox.ExportSVG";
    public static final String EXPORT_BPMN = "org.kie.workbench.common.stunner.core.client.toolbox.ExportBPMN";
    public static final String DELETE_SELECTION = "org.kie.workbench.common.stunner.core.client.toolbox.DeleteSelection";
    public static final String CLEAR_DIAGRAM = "org.kie.workbench.common.stunner.core.client.toolbox.ClearDiagram";
    public static final String CLEAR_SHAPES = "org.kie.workbench.common.stunner.core.client.toolbox.ClearShapes";
    public static final String CONFIRM_CLEAR_DIAGRAM = "org.kie.workbench.common.stunner.core.client.toolbox.ConfirmClearDiagram";
    public static final String PERFORM_AUTOMATIC_LAYOUT = "org.kie.workbench.common.stunner.core.client.toolbox.PerformAutomaticLayout";
    public static final String NEW_LINE = "\n";
    public static final String DOT = ".";
    public static final String COLON = ": ";
    public static final String OPEN_BRA = "[";
    public static final String CLOSE_BRA = "] ";
    public static final String OPEN_COMMENT = "'";
    public static final String CLOSE_COMMENT = "' ";
    private Function<String, String> nameByIdResolver;

    public static Optional<String> getDiagramValidationsErrorMessage(StunnerTranslationService translationService, Collection<DiagramElementViolation<RuleViolation>> result) {
        return CoreTranslationMessages.getValidationMessages(translationService, result).filter(StringUtils::nonEmpty);
    }

    public static String getRuleValidationMessage(StunnerTranslationService translationService, RuleViolation violation) {
        return translationService.getViolationMessage(violation);
    }

    public static String getBeanValidationMessage(StunnerTranslationService translationService, ModelBeanViolation violation) {
        return translationService.getValue(VALIDATION_PROPERTY, new Object[]{violation.getPropertyPath(), violation.getMessage()});
    }

    public static String getDomainValidationMessage(DomainViolation violation) {
        return violation.getMessage();
    }

    private static Optional<String> getValidationMessages(StunnerTranslationService translationService, Collection<DiagramElementViolation<RuleViolation>> violations) {
        return Optional.of(violations.stream().map(v -> CoreTranslationMessages.getElementValidationMessage(translationService, (DiagramElementViolation<RuleViolation>)v).orElse("")).filter(StringUtils::nonEmpty).collect(Collectors.joining()));
    }

    public static Optional<String> getElementValidationMessage(StunnerTranslationService translationService, DiagramElementViolation<RuleViolation> elementViolation) {
        String uuid = elementViolation.getUUID();
        Collection modelViolations = elementViolation.getModelViolations();
        Collection graphViolations = elementViolation.getGraphViolations();
        Collection domainViolations = elementViolation.getDomainViolations();
        if (modelViolations.isEmpty() && graphViolations.isEmpty() && domainViolations.isEmpty()) {
            return Optional.empty();
        }
        String message = Stream.of(modelViolations.stream().map(v -> CoreTranslationMessages.getBeanValidationMessage(translationService, v)), graphViolations.stream().map(v -> CoreTranslationMessages.getRuleValidationMessage(translationService, v)), domainViolations.stream().map(CoreTranslationMessages::getDomainValidationMessage)).flatMap(s -> s).collect(Collectors.joining(NEW_LINE));
        return Optional.of(message).filter(StringUtils::nonEmpty).map(msg -> {
            String name = translationService.getElementName(uuid).filter(StringUtils::nonEmpty).orElse(uuid);
            return translationService.getValue(ELEMENT, new Object[]{name, msg});
        });
    }
}

