/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule.ext.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.AbstractTreeTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.graph.util.ParentTypesMatcher;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.GraphEvaluationState;
import org.kie.workbench.common.stunner.core.rule.context.NodeContainmentContext;
import org.kie.workbench.common.stunner.core.rule.context.impl.StatefulGraphEvaluationState;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtension;
import org.kie.workbench.common.stunner.core.rule.ext.impl.AbstractParentsMatchHandler;
import org.kie.workbench.common.stunner.core.rule.handler.impl.GraphEvaluationHandlerUtils;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;

@ApplicationScoped
public class ConnectorParentsMatchContainmentHandler
extends AbstractParentsMatchHandler<ConnectorParentsMatchContainmentHandler, NodeContainmentContext> {
    private final DefinitionManager definitionManager;
    private final TreeWalkTraverseProcessor treeWalkTraverseProcessor;
    private final GraphEvaluationHandlerUtils evalUtils;

    protected ConnectorParentsMatchContainmentHandler() {
        this(null, null);
    }

    @Inject
    public ConnectorParentsMatchContainmentHandler(DefinitionManager definitionManager, TreeWalkTraverseProcessor treeWalkTraverseProcessor) {
        this.definitionManager = definitionManager;
        this.treeWalkTraverseProcessor = treeWalkTraverseProcessor;
        this.evalUtils = new GraphEvaluationHandlerUtils(definitionManager);
    }

    public Class<ConnectorParentsMatchContainmentHandler> getExtensionType() {
        return ConnectorParentsMatchContainmentHandler.class;
    }

    public Class<NodeContainmentContext> getContextType() {
        return NodeContainmentContext.class;
    }

    public boolean accepts(RuleExtension rule, NodeContainmentContext context) {
        Collection candidates = context.getCandidates();
        return candidates.stream().anyMatch(node -> this.hasAnyEdgeOfInterest((Node)node, rule.getId()));
    }

    private boolean hasAnyEdgeOfInterest(Node candidate, String edgeDefId) {
        Node node = candidate;
        return Stream.concat(node.getInEdges().stream(), node.getOutEdges().stream()).filter(e -> GraphUtils.isContentSomeDefinition().test((Element)e)).anyMatch(edge -> this.evalUtils.getElementDefinitionId((Element<?>)edge).equals(edgeDefId));
    }

    public RuleViolations evaluate(RuleExtension rule, NodeContainmentContext context) {
        return this.evaluateContainment(rule, context);
    }

    private RuleViolations evaluateContainment(RuleExtension rule, NodeContainmentContext context) {
        DefaultRuleViolations result = new DefaultRuleViolations();
        Collection candidates = context.getCandidates();
        candidates.forEach(candidate -> this.evaluateSingleContainment(result, rule, context, (Node<? extends Definition<?>, ? extends Edge>)candidate));
        return result;
    }

    private void evaluateSingleContainment(final DefaultRuleViolations result, final RuleExtension rule, final NodeContainmentContext context, Node<? extends Definition<?>, ? extends Edge> candidate) {
        final GraphEvaluationState state = context.getState();
        Graph graph = context.getState().getGraph();
        final String connectorId = rule.getId();
        this.treeWalkTraverseProcessor.traverse(graph, candidate, (TreeTraverseCallback)new AbstractTreeTraverseCallback<Graph, Node, Edge>(){

            @Override
            public boolean startNodeTraversal(Node node) {
                List inEdges = node.getInEdges();
                if (null != inEdges) {
                    inEdges.stream().forEach(this::process);
                }
                return true;
            }

            @Override
            public boolean startEdgeTraversal(Edge edge) {
                return this.process(edge);
            }

            private boolean process(Edge edge) {
                Optional<String> eId = AbstractParentsMatchHandler.getId(ConnectorParentsMatchContainmentHandler.this.definitionManager, edge);
                if (eId.isPresent() && connectorId.equals(eId.get())) {
                    Node sourceNode = state.getConnectionState().getSource(edge);
                    Node targetNode = state.getConnectionState().getTarget(edge);
                    boolean valid = new ParentTypesMatcher(() -> ConnectorParentsMatchContainmentHandler.this.definitionManager, e -> StatefulGraphEvaluationState.StatefulContainmentState.getParent(context, e), rule.getTypeArguments()).matcher().test(sourceNode, targetNode);
                    if (!valid) {
                        ConnectorParentsMatchContainmentHandler.this.addViolation(edge.getUUID(), rule, result);
                    }
                }
                return true;
            }
        });
    }
}

