/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.organizationalunit.OrganizationalUnitFactory;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

public class OrganizationalUnitFactoryImpl
implements OrganizationalUnitFactory {
    private RepositoryService repositoryService;
    private SpacesAPI spacesAPI;

    @Inject
    public OrganizationalUnitFactoryImpl(RepositoryService repositoryService, SpacesAPI spacesAPI) {
        this.repositoryService = repositoryService;
        this.spacesAPI = spacesAPI;
    }

    public OrganizationalUnit newOrganizationalUnit(SpaceInfo spaceInfo) {
        Collection contributors;
        List securityGroups;
        OrganizationalUnitImpl organizationalUnit = new OrganizationalUnitImpl(spaceInfo.getName(), spaceInfo.getDefaultGroupId());
        List repositories = spaceInfo.getRepositories();
        if (repositories != null) {
            for (RepositoryInfo alias : repositories) {
                Space space = this.spacesAPI.getSpace(organizationalUnit.getName());
                Repository repo = this.repositoryService.getRepositoryFromSpace(space, alias.getName());
                if (repo == null) continue;
                organizationalUnit.getRepositories().add(repo);
            }
        }
        if ((securityGroups = spaceInfo.getSecurityGroups()) != null) {
            organizationalUnit.getGroups().addAll(securityGroups);
        }
        if ((contributors = spaceInfo.getContributors()) != null) {
            organizationalUnit.getContributors().addAll(contributors);
        }
        return organizationalUnit;
    }
}

