/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.service.backend.util;

import org.kie.workbench.common.forms.model.ModelProperty;
import org.kie.workbench.common.forms.model.TypeKind;
import org.kie.workbench.common.forms.model.impl.ModelPropertyImpl;
import org.kie.workbench.common.forms.model.impl.TypeInfoImpl;
import org.kie.workbench.common.forms.model.util.formModel.FormModelPropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelPropertiesGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ModelPropertiesGenerator.class);

    public static ModelProperty createModelProperty(String name, String type, boolean multiple) {
        return ModelPropertiesGenerator.createModelProperty(name, type, multiple, ClassLoader.getSystemClassLoader());
    }

    public static ModelProperty createModelProperty(String name, String className, ClassLoader classLoader) {
        if (FormModelPropertiesUtil.isListType(className)) {
            return ModelPropertiesGenerator.createModelProperty(name, Object.class.getName(), true, classLoader);
        }
        return ModelPropertiesGenerator.createModelProperty(name, className, false, classLoader);
    }

    public static ModelProperty createModelProperty(String name, String className, boolean isMultiple, ClassLoader classLoader) {
        if (FormModelPropertiesUtil.isBaseType(className)) {
            return new ModelPropertyImpl(name, new TypeInfoImpl(className, isMultiple));
        }
        if (FormModelPropertiesUtil.isListType(className)) {
            return ModelPropertiesGenerator.createModelProperty(name, Object.class.getName(), true);
        }
        try {
            Class<?> clazz = classLoader.loadClass(className);
            TypeKind typeKind = clazz.isEnum() ? TypeKind.ENUM : TypeKind.OBJECT;
            return new ModelPropertyImpl(name, new TypeInfoImpl(typeKind, className, isMultiple));
        }
        catch (ClassNotFoundException e) {
            logger.warn("Unable to create property '" + name + "' for class '" + className + "':", (Throwable)e);
            return null;
        }
    }
}

