/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.UploadPack;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FileSystemState;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.InvalidPathException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.PathMatcher;
import org.uberfire.java.nio.file.PatternSyntaxException;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.attribute.UserPrincipalLookupService;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.model.CommitInfo;

public class JGitFileSystemProxy
implements JGitFileSystem {
    private String fsName;
    private Supplier<JGitFileSystem> cachedSupplier;

    public JGitFileSystemProxy(String fsName, Supplier<JGitFileSystem> cachedSupplier) {
        this.fsName = fsName;
        this.cachedSupplier = cachedSupplier;
    }

    public String getName() {
        return this.fsName;
    }

    @Override
    public Git getGit() {
        return this.cachedSupplier.get().getGit();
    }

    @Override
    public CredentialsProvider getCredential() {
        return this.cachedSupplier.get().getCredential();
    }

    @Override
    public void checkClosed() throws IllegalStateException {
        this.cachedSupplier.get().checkClosed();
    }

    @Override
    public void publishEvents(Path watchable, List<WatchEvent<?>> elist) {
        this.cachedSupplier.get().publishEvents(watchable, elist);
    }

    @Override
    public boolean isOnBatch() {
        return this.cachedSupplier.get().isOnBatch();
    }

    @Override
    public void setState(String state) {
        this.cachedSupplier.get().setState(state);
    }

    @Override
    public CommitInfo buildCommitInfo(String defaultMessage, CommentedOption op) {
        return this.cachedSupplier.get().buildCommitInfo(defaultMessage, op);
    }

    @Override
    public void setBatchCommitInfo(String defaultMessage, CommentedOption op) {
        this.cachedSupplier.get().setBatchCommitInfo(defaultMessage, op);
    }

    @Override
    public void setHadCommitOnBatchState(Path path, boolean hadCommitOnBatchState) {
        this.cachedSupplier.get().setHadCommitOnBatchState(path, hadCommitOnBatchState);
    }

    @Override
    public void setHadCommitOnBatchState(boolean value) {
        this.cachedSupplier.get().setHadCommitOnBatchState(value);
    }

    @Override
    public boolean isHadCommitOnBatchState(Path path) {
        return this.cachedSupplier.get().isHadCommitOnBatchState(path);
    }

    @Override
    public void setBatchCommitInfo(CommitInfo batchCommitInfo) {
        this.cachedSupplier.get().setBatchCommitInfo(batchCommitInfo);
    }

    @Override
    public CommitInfo getBatchCommitInfo() {
        return this.cachedSupplier.get().getBatchCommitInfo();
    }

    @Override
    public int incrementAndGetCommitCount() {
        return this.cachedSupplier.get().incrementAndGetCommitCount();
    }

    @Override
    public void resetCommitCount() {
        this.cachedSupplier.get().resetCommitCount();
    }

    @Override
    public int getNumberOfCommitsSinceLastGC() {
        return this.cachedSupplier.get().getNumberOfCommitsSinceLastGC();
    }

    public void lock() {
        this.cachedSupplier.get().lock();
    }

    public void unlock() {
        this.cachedSupplier.get().unlock();
    }

    @Override
    public void addPostponedWatchEvents(List<WatchEvent<?>> postponedWatchEvents) {
        this.cachedSupplier.get().addPostponedWatchEvents(postponedWatchEvents);
    }

    @Override
    public List<WatchEvent<?>> getPostponedWatchEvents() {
        return this.cachedSupplier.get().getPostponedWatchEvents();
    }

    @Override
    public void clearPostponedWatchEvents() {
        this.cachedSupplier.get().clearPostponedWatchEvents();
    }

    @Override
    public boolean hasPostponedEvents() {
        return this.cachedSupplier.get().hasPostponedEvents();
    }

    @Override
    public boolean hasBeenInUse() {
        return this.cachedSupplier.get().hasBeenInUse();
    }

    @Override
    public void notifyExternalUpdate() {
        this.cachedSupplier.get().notifyExternalUpdate();
    }

    @Override
    public void notifyPostCommit(int exitCode) {
        this.cachedSupplier.get().notifyPostCommit(exitCode);
    }

    @Override
    public void checkBranchAccess(ReceiveCommand command, User user) {
        this.cachedSupplier.get().checkBranchAccess(command, user);
    }

    @Override
    public void filterBranchAccess(UploadPack uploadPack, User user) {
        this.cachedSupplier.get().filterBranchAccess(uploadPack, user);
    }

    public FileSystemProvider provider() {
        return this.cachedSupplier.get().provider();
    }

    public boolean isOpen() {
        return this.cachedSupplier.get().isOpen();
    }

    public boolean isReadOnly() {
        return false;
    }

    public String getSeparator() {
        return "/";
    }

    public Iterable<Path> getRootDirectories() {
        return this.cachedSupplier.get().getRootDirectories();
    }

    public Iterable<FileStore> getFileStores() {
        return this.cachedSupplier.get().getFileStores();
    }

    public Set<String> supportedFileAttributeViews() {
        return this.cachedSupplier.get().supportedFileAttributeViews();
    }

    public Path getPath(String first, String ... more) throws InvalidPathException {
        return this.cachedSupplier.get().getPath(first, more);
    }

    public PathMatcher getPathMatcher(String syntaxAndPattern) throws IllegalArgumentException, PatternSyntaxException, UnsupportedOperationException {
        return this.cachedSupplier.get().getPathMatcher(syntaxAndPattern);
    }

    public UserPrincipalLookupService getUserPrincipalLookupService() throws UnsupportedOperationException {
        return this.cachedSupplier.get().getUserPrincipalLookupService();
    }

    public WatchService newWatchService() throws UnsupportedOperationException, IOException {
        return this.cachedSupplier.get().newWatchService();
    }

    public void close() {
        this.cachedSupplier.get().close();
    }

    public void dispose() {
        this.cachedSupplier.get().dispose();
    }

    public String id() {
        return this.fsName;
    }

    public FileSystemState getState() {
        return this.cachedSupplier.get().getState();
    }

    public JGitFileSystem getRealJGitFileSystem() {
        return this.cachedSupplier.get();
    }

    public boolean equals(Object obj) {
        return this.cachedSupplier.get().equals(obj);
    }

    public int hashCode() {
        return this.cachedSupplier.get().hashCode();
    }

    public String toString() {
        return this.cachedSupplier.get().toString();
    }
}

