/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend.definition.adapter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;

public class ReflectionAdapterUtils {
    public static <T, A extends Annotation, V> V getAnnotatedFieldValue(T object, Class<A> annotationType) throws IllegalAccessException {
        Class<Object> c = object.getClass();
        while (!c.isAssignableFrom(Object.class)) {
            V result = ReflectionAdapterUtils.getAnnotatedFieldValue(object, c, annotationType);
            if (null != result) {
                return result;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    public static <T, V> Set<V> getFieldValues(T object, Set<String> fieldNames) throws IllegalAccessException {
        LinkedHashSet<V> result = new LinkedHashSet<V>();
        if (null != fieldNames) {
            for (String fieldName : fieldNames) {
                Class<Object> c = object.getClass();
                while (!c.isAssignableFrom(Object.class)) {
                    V result1 = ReflectionAdapterUtils.getFieldValue(object, c, fieldName);
                    if (null != result1) {
                        result.add(result1);
                    }
                    c = c.getSuperclass();
                }
            }
        }
        return result;
    }

    public static <T, V> V getFieldValue(T object, String fieldName) throws IllegalAccessException {
        Class<Object> c = object.getClass();
        while (!c.isAssignableFrom(Object.class)) {
            V result = ReflectionAdapterUtils.getFieldValue(object, c, fieldName);
            if (null != result) {
                return result;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    public static <T, A extends Annotation, V> V getAnnotatedFieldValue(T object, Class<?> sourceType, Class<A> annotationType) throws IllegalAccessException {
        Object result = null;
        Field[] fields = sourceType.getDeclaredFields();
        if (null != fields) {
            for (Field field : fields) {
                A annotation = field.getAnnotation(annotationType);
                if (null == annotation) continue;
                field.setAccessible(true);
                result = field.get(object);
                break;
            }
        }
        return (V)result;
    }

    public static <T, V> V getFieldValue(T object, Class<?> sourceType, String fieldName) throws IllegalAccessException {
        Object result = null;
        Field[] fields = sourceType.getDeclaredFields();
        if (null != fields) {
            for (Field field : fields) {
                if (!field.getName().equals(fieldName)) continue;
                field.setAccessible(true);
                result = field.get(object);
                break;
            }
        }
        return (V)result;
    }

    public static <T> Field getField(T object, String fieldName) throws SecurityException {
        Class<Object> c = object.getClass();
        while (!c.isAssignableFrom(Object.class)) {
            Field result = ReflectionAdapterUtils.getField(c, fieldName);
            if (null != result) {
                return result;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    public static Field getField(Class<?> sourceType, String fieldName) throws SecurityException {
        Field[] fields = sourceType.getDeclaredFields();
        if (null != fields) {
            for (Field field : fields) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
        }
        return null;
    }

    public static List<Field> getFields(Class<?> sourceType) throws SecurityException {
        return Stream.of(sourceType.getDeclaredFields()).collect(Collectors.toList());
    }

    public static <T extends Annotation> T getClassAnnotation(Class<?> type, Class<T> annotationType) {
        Class<Object> c = type;
        while (!c.isAssignableFrom(Object.class)) {
            T result = c.getAnnotation(annotationType);
            if (null != result) {
                return result;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    public static <T extends Annotation> Collection<Field> getFieldAnnotations(Class<?> type, Class<T> annotationType) {
        if (null != type && null != annotationType) {
            LinkedList<Field> result = new LinkedList<Field>();
            Class<Object> c = type;
            while (!c.isAssignableFrom(Object.class)) {
                Collection<Field> fields = ReflectionAdapterUtils._getFieldAnnotations(c, annotationType);
                if (null != fields && !fields.isEmpty()) {
                    result.addAll(fields);
                }
                c = c.getSuperclass();
            }
            return result;
        }
        return null;
    }

    private static <T extends Annotation> Collection<Field> _getFieldAnnotations(Class<?> type, Class<T> annotationType) {
        Field[] fields = type.getDeclaredFields();
        if (null != fields) {
            LinkedList<Field> result = new LinkedList<Field>();
            for (Field field : fields) {
                T annotation = field.getAnnotation(annotationType);
                if (null == annotation) continue;
                result.add(field);
            }
            return result;
        }
        return null;
    }

    public static String getDefinitionId(Class<?> type) {
        return BindableAdapterUtils.getDefinitionId(type);
    }

    public static String getPropertyId(Object pojo) {
        return BindableAdapterUtils.getPropertyId(pojo.getClass());
    }
}

