/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.penta;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.penta.AbstractPentaJoiner;
import org.optaplanner.core.impl.score.stream.penta.SinglePentaJoiner;

public final class CompositePentaJoiner<A, B, C, D, E>
extends AbstractPentaJoiner<A, B, C, D, E> {
    private final List<SinglePentaJoiner<A, B, C, D, E>> joinerList;
    private final QuadFunction<A, B, C, D, ?>[] leftMappings;
    private final Function<E, ?>[] rightMappings;

    CompositePentaJoiner(List<SinglePentaJoiner<A, B, C, D, E>> joinerList) {
        if (joinerList.isEmpty()) {
            throw new IllegalArgumentException("The joinerList (" + joinerList + ") must not be empty.");
        }
        this.joinerList = joinerList;
        this.leftMappings = (QuadFunction[])joinerList.stream().map(SinglePentaJoiner::getLeftMapping).toArray(QuadFunction[]::new);
        this.rightMappings = (Function[])joinerList.stream().map(SinglePentaJoiner::getRightMapping).toArray(Function[]::new);
    }

    public List<SinglePentaJoiner<A, B, C, D, E>> getJoinerList() {
        return this.joinerList;
    }

    @Override
    public QuadFunction<A, B, C, D, Object> getLeftMapping(int index) {
        this.assertMappingIndex(index);
        return this.leftMappings[index];
    }

    @Override
    public QuadFunction<A, B, C, D, Object[]> getLeftCombinedMapping() {
        QuadFunction[] mappings = (QuadFunction[])IntStream.range(0, this.joinerList.size()).mapToObj(this::getLeftMapping).toArray(QuadFunction[]::new);
        return (a, b, c, d) -> Arrays.stream(mappings).map(f -> f.apply(a, b, c, d)).toArray();
    }

    @Override
    public JoinerType[] getJoinerTypes() {
        return (JoinerType[])this.joinerList.stream().map(SinglePentaJoiner::getJoinerType).toArray(JoinerType[]::new);
    }

    @Override
    public Function<E, Object> getRightMapping(int index) {
        this.assertMappingIndex(index);
        return this.rightMappings[index];
    }

    @Override
    public Function<E, Object[]> getRightCombinedMapping() {
        Function[] mappings = (Function[])IntStream.range(0, this.joinerList.size()).mapToObj(this::getRightMapping).toArray(Function[]::new);
        return e -> Arrays.stream(mappings).map(f -> f.apply(e)).toArray();
    }
}

