/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Specializes;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.dashbuilder.dataprovider.SQLDataSourceLocatorCDI;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.dataset.def.SQLDataSourceDef;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceRuntimeManager;
import org.kie.workbench.common.screens.datasource.management.backend.core.impl.AbstractDataSource;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDefInfo;
import org.kie.workbench.common.screens.datasource.management.service.DataSourceDefQueryService;

@ApplicationScoped
@Specializes
public class KieSQLDataSourceLocator
extends SQLDataSourceLocatorCDI {
    private DataSourceDefQueryService queryService;
    private DataSourceRuntimeManager runtimeManager;

    @Inject
    public KieSQLDataSourceLocator(DataSourceDefQueryService queryService, DataSourceRuntimeManager runtimeManager) {
        this.queryService = queryService;
        this.runtimeManager = runtimeManager;
    }

    public DataSource lookup(SQLDataSetDef def) throws Exception {
        return ((AbstractDataSource)this.runtimeManager.lookupDataSource(def.getDataSource())).getInternalDataSource();
    }

    public List<SQLDataSourceDef> list() {
        Collection dataSourceDefInfos = this.queryService.findGlobalDataSources(true);
        ArrayList<SQLDataSourceDef> result = new ArrayList<SQLDataSourceDef>();
        for (DataSourceDefInfo dataSourceDefInfo : dataSourceDefInfos) {
            result.add(new SQLDataSourceDef(dataSourceDefInfo.getUuid(), dataSourceDefInfo.getName()));
        }
        return result;
    }
}

