/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.drools.workbench.models.datamodel.rule.Attribute;
import org.drools.workbench.models.datamodel.workitems.PortableParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DescriptionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.XLSColumnUtilities;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;

public class SubHeaderBuilder {
    private static final int COLUMN_TYPE_ROW = 5;
    private static final int FIELD_ROW = 7;
    private static final int HEADER_TITLE_ROW = 8;
    private final GuidedDecisionTable52 dtable;
    private final String ACTION = "ACTION";
    private final String METADATA = "METADATA";
    private final String CONDITION = "CONDITION";
    private final XLSColumnUtilities columnUtilities;
    private final Row headerRow;
    private final Row fieldRow;
    private final Row headerTitleRow;
    private final List<String> addedInserts = new ArrayList<String>();
    private int targetColumnIndex = 0;

    public SubHeaderBuilder(Sheet sheet, GuidedDecisionTable52 dtable, PackageDataModelOracle dmo) {
        PortablePreconditions.checkNotNull((String)"sheet", (Object)sheet);
        this.dtable = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"dtable", (Object)dtable);
        this.columnUtilities = new XLSColumnUtilities(dtable, (PackageDataModelOracle)PortablePreconditions.checkNotNull((String)"dmo", (Object)dmo), false);
        this.headerRow = sheet.createRow(5);
        this.fieldRow = sheet.createRow(7);
        this.headerTitleRow = sheet.createRow(8);
    }

    public void build() {
        List expandedColumns = this.dtable.getExpandedColumns();
        for (int sourceColumnIndex = 0; sourceColumnIndex < expandedColumns.size(); ++sourceColumnIndex) {
            BaseColumn baseColumn = (BaseColumn)expandedColumns.get(sourceColumnIndex);
            if (baseColumn instanceof AttributeCol52) {
                this.makeAttribute((AttributeCol52)baseColumn);
            } else if (baseColumn instanceof MetadataCol52) {
                this.makeMetadata((MetadataCol52)baseColumn);
            } else if (baseColumn instanceof ConditionCol52) {
                this.makeCondition((ConditionCol52)baseColumn);
            } else if (baseColumn instanceof ActionCol52) {
                this.makeAction(sourceColumnIndex, baseColumn);
            } else {
                if (baseColumn instanceof RowNumberCol52) continue;
                if (!(baseColumn instanceof DescriptionCol52)) {
                    throw new IllegalArgumentException("TODO REMOTE THIS");
                }
            }
            ++this.targetColumnIndex;
        }
    }

    private void makeAction(int sourceColumnIndex, BaseColumn baseColumn) {
        if (baseColumn instanceof ActionWorkItemSetFieldCol52) {
            this.makeWorkItemSetField(sourceColumnIndex, (ActionWorkItemSetFieldCol52)baseColumn);
        } else if (baseColumn instanceof ActionSetFieldCol52) {
            this.makeSetField((ActionSetFieldCol52)baseColumn);
        } else if (baseColumn instanceof ActionInsertFactCol52) {
            this.makeInsert((ActionInsertFactCol52)baseColumn);
        } else if (baseColumn instanceof ActionWorkItemCol52) {
            this.makeWorkItem((ActionWorkItemCol52)baseColumn);
        } else if (baseColumn instanceof ActionRetractFactCol52) {
            this.makeRetract((ActionRetractFactCol52)baseColumn);
        }
    }

    private void makeHeaderAndTitle(String action, String header) {
        this.headerRow.createCell(this.targetColumnIndex).setCellValue(action);
        this.headerTitleRow.createCell(this.targetColumnIndex).setCellValue(header);
    }

    private void makeWorkItem(ActionWorkItemCol52 column) {
        PortableWorkDefinition workItemDefinition = column.getWorkItemDefinition();
        String wimManagerName = this.getWorkItemManagerVariableName(workItemDefinition.getName());
        String wiParamName = this.getWorkItemParameterVariableName(workItemDefinition.getName());
        StringBuilder builder = new StringBuilder();
        for (PortableParameterDefinition parameterDefinition : workItemDefinition.getParameters()) {
            builder.append(wiParamName);
            builder.append(".getParameters().put(");
            builder.append("\"");
            builder.append(parameterDefinition.getName());
            builder.append("\", ");
            builder.append(parameterDefinition.asString());
            builder.append(");\n");
        }
        String format = MessageFormat.format("org.drools.core.process.instance.WorkItemManager {0} = (org.drools.core.process.instance.WorkItemManager) drools.getWorkingMemory().getWorkItemManager();\norg.drools.core.process.instance.impl.WorkItemImpl {1} = new org.drools.core.process.instance.impl.WorkItemImpl();\n{1}.setName( \"{2}\" );\n{3}{0}.internalExecuteWorkItem( {1} );", wimManagerName, wiParamName, workItemDefinition.getName(), builder.toString());
        this.makeHeaderAndTitle("ACTION", column.getHeader());
        this.fieldRow.createCell(this.targetColumnIndex).setCellValue(format);
    }

    private String getWorkItemParameterVariableName(String name) {
        return String.format("wi%sParameter", name);
    }

    private String getWorkItemManagerVariableName(String name) {
        return String.format("wi%sManager", name);
    }

    private void makeRetract(ActionRetractFactCol52 column) {
        this.makeHeaderAndTitle("ACTION", column.getHeader());
        this.fieldRow.createCell(this.targetColumnIndex).setCellValue("retract( $param );");
    }

    private void makeInsert(ActionInsertFactCol52 column) {
        if (!this.addedInserts.contains(column.getBoundName())) {
            this.makeHeaderAndTitle("ACTION", "");
            this.fieldRow.createCell(this.targetColumnIndex).setCellValue(MessageFormat.format("{0} {1} = new {2}(); insert( {1} );", column.getFactType(), column.getBoundName(), column.getFactType()));
            this.addedInserts.add(column.getBoundName());
            ++this.targetColumnIndex;
        }
        this.makeHeaderAndTitle("ACTION", column.getHeader());
        this.fieldRow.createCell(this.targetColumnIndex).setCellValue(this.makeSetMethod(column.getBoundName(), column.getFactField(), "$param"));
    }

    private void makeSetField(ActionSetFieldCol52 column) {
        this.makeSetField(column, "$param");
    }

    private void makeWorkItemSetField(int sourceColumnIndex, ActionWorkItemSetFieldCol52 column) {
        this.makeSetField((ActionSetFieldCol52)column, String.format("(%s) %s.getResult( \"Result\" )", this.getColumnDataType(sourceColumnIndex), this.getWorkItemParameterVariableName(column.getWorkItemName())));
    }

    private void makeSetField(ActionSetFieldCol52 column, String value) {
        this.makeHeaderAndTitle("ACTION", column.getHeader());
        this.fieldRow.createCell(this.targetColumnIndex).setCellValue(this.makeSetMethod(column.getBoundName(), column.getFactField(), value));
    }

    private void makeCondition(ConditionCol52 column) {
        this.makeHeaderAndTitle("CONDITION", column.getHeader());
        if (column.getConstraintValueType() == 5) {
            if (column.getFactField().contains("$param")) {
                this.fieldRow.createCell(this.targetColumnIndex).setCellValue(String.format("eval( %s )", column.getFactField()));
            } else {
                this.fieldRow.createCell(this.targetColumnIndex).setCellValue(String.format("eval( %s )", "$param"));
            }
        } else if (column.getBinding() == null || column.getBinding().trim().isEmpty()) {
            this.fieldRow.createCell(this.targetColumnIndex).setCellValue(String.format(this.getTemplate(column.getConstraintValueType()), column.getFactField(), this.getOperator(column)));
        } else {
            this.fieldRow.createCell(this.targetColumnIndex).setCellValue(String.format(this.getTemplateWithBinds(column.getConstraintValueType()), column.getBinding(), column.getFactField(), this.getOperator(column)));
        }
    }

    private String getTemplate(int constraintValueType) {
        if (constraintValueType == 3) {
            return "%s %s ( $param )";
        }
        return "%s %s $param";
    }

    private String getTemplateWithBinds(int constraintValueType) {
        if (constraintValueType == 3) {
            return "%s : %s %s ( $param )";
        }
        return "%s : %s %s $param";
    }

    private String getOperator(ConditionCol52 column) {
        if (Objects.equals("== null", column.getOperator())) {
            return "==";
        }
        if (Objects.equals("!= null", column.getOperator())) {
            return "!=";
        }
        return column.getOperator();
    }

    private void makeAttribute(AttributeCol52 column) {
        if (Objects.equals(Attribute.NEGATE_RULE.getAttributeName(), column.getAttribute())) {
            throw new UnsupportedOperationException("Conversion of the negate attribute is not supported.");
        }
        this.headerRow.createCell(this.targetColumnIndex).setCellValue(this.getAttribute(column));
    }

    private String getAttribute(AttributeCol52 column) {
        if (Objects.equals(Attribute.SALIENCE.getAttributeName(), column.getAttribute())) {
            return "PRIORITY";
        }
        return column.getAttribute().toUpperCase();
    }

    private void makeMetadata(MetadataCol52 column) {
        this.makeHeaderAndTitle("METADATA", column.getHeader());
        this.fieldRow.createCell(this.targetColumnIndex).setCellValue(String.format("%s( $param )", column.getMetadata()));
    }

    private String makeSetMethod(String boundName, String factField, String value) {
        return String.format("%s.set%s%s( %s );", boundName, factField.substring(0, 1).toUpperCase(), factField.substring(1), value);
    }

    private String getColumnDataType(int columnIndex) {
        return this.columnUtilities.getType((BaseColumn)this.dtable.getExpandedColumns().get(columnIndex));
    }
}

