/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.archetype.mgmt.client.modal;

import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.GAV;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.archetype.mgmt.shared.exceptions.ArchetypeAlreadyExistsException;
import org.kie.workbench.common.screens.archetype.mgmt.shared.exceptions.InvalidArchetypeException;
import org.kie.workbench.common.screens.archetype.mgmt.shared.exceptions.MavenExecutionException;
import org.kie.workbench.common.screens.archetype.mgmt.shared.services.ArchetypeService;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;

@Dependent
public class AddArchetypeModalPresenter
implements HasBusyIndicator {
    private final View view;
    private final TranslationService ts;
    private final Caller<ArchetypeService> archetypeService;
    private final BusyIndicatorView busyIndicatorView;

    @Inject
    public AddArchetypeModalPresenter(View view, TranslationService ts, Caller<ArchetypeService> archetypeService, BusyIndicatorView busyIndicatorView) {
        this.view = view;
        this.ts = ts;
        this.archetypeService = archetypeService;
        this.busyIndicatorView = busyIndicatorView;
    }

    @PostConstruct
    public void postConstruct() {
        this.view.init(this);
    }

    public void show() {
        this.view.resetAll();
        this.view.show();
    }

    public void hide() {
        this.view.hide();
    }

    public void add() {
        String archetypeGroupId = this.view.getArchetypeGroupId();
        String archetypeArtifactId = this.view.getArchetypeArtifactId();
        String archetypeVersion = this.view.getArchetypeVersion();
        this.validateFields(archetypeGroupId, archetypeArtifactId, archetypeVersion, () -> {
            this.beginAddArchetype();
            GAV archetypeGAV = new GAV(archetypeGroupId.trim(), archetypeArtifactId.trim(), archetypeVersion.trim());
            ((ArchetypeService)this.archetypeService.call(v -> {
                this.endAddArchetype();
                this.hide();
            }, this.addActionErrorCallback())).add(archetypeGAV);
        });
    }

    private void beginAddArchetype() {
        this.view.enableAddButton(false);
        this.view.enableFields(false);
        this.busyIndicatorView.showBusyIndicator(this.ts.getTranslation("ArchetypeManagement.Loading"));
    }

    private void endAddArchetype() {
        this.view.enableAddButton(true);
        this.view.enableFields(true);
        this.busyIndicatorView.hideBusyIndicator();
    }

    private ErrorCallback<Object> addActionErrorCallback() {
        return (message, throwable) -> {
            this.endAddArchetype();
            if (throwable instanceof ArchetypeAlreadyExistsException) {
                this.view.showGeneralError(this.ts.getTranslation("ArchetypeManagement.ArchetypeAlreadyExistsMessage"));
                return false;
            }
            if (throwable instanceof MavenExecutionException) {
                this.view.showGeneralError(this.ts.format("ArchetypeManagement.MavenExecutionExceptionMessage", new Object[]{throwable.getMessage()}));
                return false;
            }
            if (throwable instanceof InvalidArchetypeException) {
                this.view.showGeneralError(this.ts.getTranslation("ArchetypeManagement.InvalidArchetypeExceptionMessage"));
                return false;
            }
            return true;
        };
    }

    private void validateFields(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion, Runnable callback) {
        String errorMsg;
        this.view.clearErrors();
        boolean isValid = true;
        Predicate<String> isInvalidContent = content -> content == null || content.trim().isEmpty();
        if (isInvalidContent.test(archetypeGroupId)) {
            errorMsg = this.ts.format("ArchetypeManagement.EmptyFieldValidation", new Object[]{this.ts.getTranslation("ArchetypeGroupId")});
            this.view.showArchetypeGroupIdError(errorMsg);
            isValid = false;
        }
        if (isInvalidContent.test(archetypeArtifactId)) {
            errorMsg = this.ts.format("ArchetypeManagement.EmptyFieldValidation", new Object[]{this.ts.getTranslation("ArchetypeArtifactId")});
            this.view.showArchetypeArtifactIdError(errorMsg);
            isValid = false;
        }
        if (isInvalidContent.test(archetypeVersion)) {
            errorMsg = this.ts.format("ArchetypeManagement.EmptyFieldValidation", new Object[]{this.ts.getTranslation("ArchetypeVersion")});
            this.view.showArchetypeVersionError(errorMsg);
            isValid = false;
        }
        if (isValid) {
            callback.run();
        }
    }

    public void cancel() {
        this.hide();
    }

    public void showBusyIndicator(String message) {
        this.busyIndicatorView.showBusyIndicator(message);
    }

    public void hideBusyIndicator() {
        this.busyIndicatorView.hideBusyIndicator();
    }

    public static interface View
    extends UberElemental<AddArchetypeModalPresenter> {
        public void show();

        public void hide();

        public void showGeneralError(String var1);

        public void showArchetypeGroupIdError(String var1);

        public void showArchetypeArtifactIdError(String var1);

        public void showArchetypeVersionError(String var1);

        public void clearErrors();

        public String getArchetypeGroupId();

        public String getArchetypeArtifactId();

        public String getArchetypeVersion();

        public void resetAll();

        public void enableAddButton(boolean var1);

        public void enableFields(boolean var1);
    }
}

