/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.core;

import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Date {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ToLocaleDateStringLocalesUnionType {
    @JsOverlay
    static ToLocaleDateStringLocalesUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default String[] asStringArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }

    @JsOverlay
    default boolean isStringArray() {
      return (Object) this instanceof Object[];
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ToLocaleStringLocalesUnionType {
    @JsOverlay
    static ToLocaleStringLocalesUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default String[] asStringArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }

    @JsOverlay
    default boolean isStringArray() {
      return (Object) this instanceof Object[];
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ToLocaleTimeStringLocalesUnionType {
    @JsOverlay
    static ToLocaleTimeStringLocalesUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default String[] asStringArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }

    @JsOverlay
    default boolean isStringArray() {
      return (Object) this instanceof Object[];
    }
  }

  public static native double UTC(
      double year,
      double month,
      double date,
      double hours,
      double minute,
      double second,
      double ms);

  public static native double UTC(
      double year, double month, double date, double hours, double minute, double second);

  public static native double UTC(
      double year, double month, double date, double hours, double minute);

  public static native double UTC(double year, double month, double date, double hours);

  public static native double UTC(double year, double month, double date);

  public static native double UTC(double year, double month);

  public static native double now();

  public static native double parse(Object date);

  public Date() {}

  public Date(
      Object yr_num,
      Object mo_num,
      Object day_num,
      Object hr_num,
      Object min_num,
      Object sec_num,
      Object ms_num) {}

  public Date(
      Object yr_num,
      Object mo_num,
      Object day_num,
      Object hr_num,
      Object min_num,
      Object sec_num) {}

  public Date(Object yr_num, Object mo_num, Object day_num, Object hr_num, Object min_num) {}

  public Date(Object yr_num, Object mo_num, Object day_num, Object hr_num) {}

  public Date(Object yr_num, Object mo_num, Object day_num) {}

  public Date(Object yr_num, Object mo_num) {}

  public Date(Object yr_num) {}

  public native double getDate();

  public native double getDay();

  public native double getFullYear();

  public native double getHours();

  public native double getMilliseconds();

  public native double getMinutes();

  public native double getMonth();

  public native double getSeconds();

  public native double getTime();

  public native double getTimezoneOffset();

  public native double getUTCDate();

  public native double getUTCDay();

  public native double getUTCFullYear();

  public native double getUTCHours();

  public native double getUTCMilliseconds();

  public native double getUTCMinutes();

  public native double getUTCMonth();

  public native double getUTCSeconds();

  public native double getYear();

  public native double setDate(double dayValue);

  public native double setFullYear(double yearValue, double monthValue, double dayValue);

  public native double setFullYear(double yearValue, double monthValue);

  public native double setFullYear(double yearValue);

  public native double setHours(
      double hoursValue, double minutesValue, double secondsValue, double msValue);

  public native double setHours(double hoursValue, double minutesValue, double secondsValue);

  public native double setHours(double hoursValue, double minutesValue);

  public native double setHours(double hoursValue);

  public native double setMilliseconds(double millisecondsValue);

  public native double setMinutes(double minutesValue, double secondsValue, double msValue);

  public native double setMinutes(double minutesValue, double secondsValue);

  public native double setMinutes(double minutesValue);

  public native double setMonth(double monthValue, double dayValue);

  public native double setMonth(double monthValue);

  public native double setSeconds(double secondsValue, double msValue);

  public native double setSeconds(double secondsValue);

  public native double setTime(double timeValue);

  public native double setUTCDate(double dayValue);

  public native double setUTCFullYear(double yearValue, double monthValue, double dayValue);

  public native double setUTCFullYear(double yearValue, double monthValue);

  public native double setUTCFullYear(double yearValue);

  public native double setUTCHours(
      double hoursValue, double minutesValue, double secondsValue, double msValue);

  public native double setUTCHours(double hoursValue, double minutesValue, double secondsValue);

  public native double setUTCHours(double hoursValue, double minutesValue);

  public native double setUTCHours(double hoursValue);

  public native double setUTCMilliseconds(double millisecondsValue);

  public native double setUTCMinutes(double minutesValue, double secondsValue, double msValue);

  public native double setUTCMinutes(double minutesValue, double secondsValue);

  public native double setUTCMinutes(double minutesValue);

  public native double setUTCMonth(double monthValue, double dayValue);

  public native double setUTCMonth(double monthValue);

  public native double setUTCSeconds(double secondsValue, double msValue);

  public native double setUTCSeconds(double secondsValue);

  public native double setYear(double yearValue);

  public native String toDateString();

  public native String toGMTString();

  public native String toISOString();

  public native String toJSON();

  public native String toJSON(Object ignoredKey);

  public native String toLocaleDateString();

  @JsOverlay
  public final String toLocaleDateString(String locales, JsObject options) {
    return toLocaleDateString(
        Js.<ToLocaleDateStringLocalesUnionType>uncheckedCast(locales), options);
  }

  @JsOverlay
  public final String toLocaleDateString(String[] locales, JsObject options) {
    return toLocaleDateString(
        Js.<ToLocaleDateStringLocalesUnionType>uncheckedCast(locales), options);
  }

  @JsOverlay
  public final String toLocaleDateString(String locales) {
    return toLocaleDateString(Js.<ToLocaleDateStringLocalesUnionType>uncheckedCast(locales));
  }

  @JsOverlay
  public final String toLocaleDateString(String[] locales) {
    return toLocaleDateString(Js.<ToLocaleDateStringLocalesUnionType>uncheckedCast(locales));
  }

  public native String toLocaleDateString(
      ToLocaleDateStringLocalesUnionType locales, JsObject options);

  public native String toLocaleDateString(ToLocaleDateStringLocalesUnionType locales);

  public native String toLocaleFormat(String formatString);

  public native String toLocaleString();

  @JsOverlay
  public final String toLocaleString(String locales, JsObject options) {
    return toLocaleString(Js.<ToLocaleStringLocalesUnionType>uncheckedCast(locales), options);
  }

  @JsOverlay
  public final String toLocaleString(String[] locales, JsObject options) {
    return toLocaleString(Js.<ToLocaleStringLocalesUnionType>uncheckedCast(locales), options);
  }

  @JsOverlay
  public final String toLocaleString(String locales) {
    return toLocaleString(Js.<ToLocaleStringLocalesUnionType>uncheckedCast(locales));
  }

  @JsOverlay
  public final String toLocaleString(String[] locales) {
    return toLocaleString(Js.<ToLocaleStringLocalesUnionType>uncheckedCast(locales));
  }

  public native String toLocaleString(ToLocaleStringLocalesUnionType locales, JsObject options);

  public native String toLocaleString(ToLocaleStringLocalesUnionType locales);

  public native String toLocaleTimeString();

  @JsOverlay
  public final String toLocaleTimeString(String locales, JsObject options) {
    return toLocaleTimeString(
        Js.<ToLocaleTimeStringLocalesUnionType>uncheckedCast(locales), options);
  }

  @JsOverlay
  public final String toLocaleTimeString(String[] locales, JsObject options) {
    return toLocaleTimeString(
        Js.<ToLocaleTimeStringLocalesUnionType>uncheckedCast(locales), options);
  }

  @JsOverlay
  public final String toLocaleTimeString(String locales) {
    return toLocaleTimeString(Js.<ToLocaleTimeStringLocalesUnionType>uncheckedCast(locales));
  }

  @JsOverlay
  public final String toLocaleTimeString(String[] locales) {
    return toLocaleTimeString(Js.<ToLocaleTimeStringLocalesUnionType>uncheckedCast(locales));
  }

  public native String toLocaleTimeString(
      ToLocaleTimeStringLocalesUnionType locales, JsObject options);

  public native String toLocaleTimeString(ToLocaleTimeStringLocalesUnionType locales);

  public native String toSource();

  public native String toString();

  public native String toTimeString();

  public native String toUTCString();

  public native double valueOf();
}
