/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.core;

import java.lang.Object;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Map<KEY, VALUE> implements Iterable<Map.IterableTypeParameterArrayUnionType[]> {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ConstructorIterableIterableTypeParameterArrayUnionType<KEY, VALUE> {
    @JsOverlay
    static ConstructorIterableIterableTypeParameterArrayUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default KEY asKEY() {
      return Js.cast(this);
    }

    @JsOverlay
    default VALUE asVALUE() {
      return Js.cast(this);
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ConstructorIterableUnionType<KEY, VALUE> {
    @JsOverlay
    static ConstructorIterableUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ConstructorIterableIterableTypeParameterArrayUnionType<KEY, VALUE>[][]
        asConstructorIterableArrayArrayUnionTypeArrayArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default Iterable<ConstructorIterableIterableTypeParameterArrayUnionType[]> asIterable() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isConstructorIterableArrayArrayUnionTypeArrayArray() {
      return (Object) this instanceof Object[];
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface EntriesIteratorIterableTypeParameterArrayUnionType<KEY, VALUE> {
    @JsOverlay
    static EntriesIteratorIterableTypeParameterArrayUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default KEY asKEY() {
      return Js.cast(this);
    }

    @JsOverlay
    default VALUE asVALUE() {
      return Js.cast(this);
    }
  }

  @JsFunction
  public interface ForEachP0CallbackFn<KEY, VALUE> {
    Object onInvoke(VALUE p0, KEY p1, Map<KEY, VALUE> p2);
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface IterableTypeParameterArrayUnionType<KEY, VALUE> {
    @JsOverlay
    static IterableTypeParameterArrayUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default KEY asKEY() {
      return Js.cast(this);
    }

    @JsOverlay
    default VALUE asVALUE() {
      return Js.cast(this);
    }
  }

  public double size;

  public Map() {}

  public Map(ConstructorIterableIterableTypeParameterArrayUnionType<KEY, VALUE>[][] iterable) {}

  public Map(ConstructorIterableUnionType<KEY, VALUE> iterable) {}

  public Map(Iterable<ConstructorIterableIterableTypeParameterArrayUnionType[]> iterable) {}

  public native void clear();

  public native boolean delete(KEY p0);

  public native IteratorIterable<EntriesIteratorIterableTypeParameterArrayUnionType[]> entries();

  public native Object forEach(ForEachP0CallbackFn<KEY, VALUE> p0, Object p1);

  public native Object forEach(ForEachP0CallbackFn<KEY, VALUE> p0);

  public native VALUE get(KEY p0);

  public native boolean has(KEY p0);

  public native IteratorIterable<KEY> keys();

  public native Map<KEY, VALUE> set(KEY p0, VALUE p1);

  public native IteratorIterable<VALUE> values();
}
