/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.core.ArrayBuffer;
import elemental2.core.ArrayBufferView;
import elemental2.core.Function;
import elemental2.core.JsObject;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class XMLHttpRequest implements EventTarget {
  @JsFunction
  public interface OnabortCallbackFn {
    void onInvoke(ProgressEvent p0);
  }

  @JsFunction
  public interface OnloadCallbackFn {
    void onInvoke(ProgressEvent p0);
  }

  @JsFunction
  public interface OnloadendCallbackFn {
    void onInvoke(ProgressEvent p0);
  }

  @JsFunction
  public interface OnloadstartCallbackFn {
    void onInvoke(ProgressEvent p0);
  }

  @JsFunction
  public interface OnprogressCallbackFn {
    void onInvoke(ProgressEvent p0);
  }

  @JsFunction
  public interface OntimeoutCallbackFn {
    void onInvoke(ProgressEvent p0);
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ResponseUnionType {
    @JsOverlay
    static ResponseUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default JsObject asJsObject() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isJsObject() {
      return (Object) this instanceof JsObject;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface SendDataUnionType {
    @JsOverlay
    static SendDataUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ArrayBuffer asArrayBuffer() {
      return Js.cast(this);
    }

    @JsOverlay
    default ArrayBufferView asArrayBufferView() {
      return Js.cast(this);
    }

    @JsOverlay
    default Blob asBlob() {
      return Js.cast(this);
    }

    @JsOverlay
    default Document asDocument() {
      return Js.cast(this);
    }

    @JsOverlay
    default FormData asFormData() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isArrayBuffer() {
      return (Object) this instanceof ArrayBuffer;
    }

    @JsOverlay
    default boolean isArrayBufferView() {
      return (Object) this instanceof ArrayBufferView;
    }

    @JsOverlay
    default boolean isBlob() {
      return (Object) this instanceof Blob;
    }

    @JsOverlay
    default boolean isDocument() {
      return (Object) this instanceof Document;
    }

    @JsOverlay
    default boolean isFormData() {
      return (Object) this instanceof FormData;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  public static double DONE;
  public static double HEADERS_RECEIVED;
  public static double LOADING;
  public static double OPENED;
  public static double UNSENT;
  public ArrayBuffer mozResponseArrayBuffer;
  public OnabortCallbackFn onabort;
  public Function onerror;
  public OnloadCallbackFn onload;
  public OnloadendCallbackFn onloadend;
  public OnloadstartCallbackFn onloadstart;
  public OnprogressCallbackFn onprogress;
  public Function onreadystatechange;
  public OntimeoutCallbackFn ontimeout;
  public double readyState;
  public ResponseUnionType response;
  public String responseText;
  public String responseType;
  public String responseURL;
  public Document responseXML;
  public double status;
  public String statusText;
  public XMLHttpRequestUpload upload;
  public boolean withCredentials;

  public native void abort();

  public native void addEventListener(
      String type, EventListener listener, EventTarget.AddEventListenerOptionsUnionType options);

  public native void addEventListener(String type, EventListener listener);

  public native boolean dispatchEvent(Event evt);

  public native String getAllResponseHeaders();

  public native String getResponseHeader(String header);

  public native void open(String method, String url, boolean async, String user, String password);

  public native void open(String method, String url, boolean async, String user);

  public native void open(String method, String url, boolean async);

  public native void open(String method, String url);

  public native void overrideMimeType(String mimeType);

  public native void removeEventListener(
      String type, EventListener listener, EventTarget.RemoveEventListenerOptionsUnionType options);

  public native void removeEventListener(String type, EventListener listener);

  public native void send();

  @JsOverlay
  public final void send(ArrayBuffer data) {
    send(Js.<SendDataUnionType>uncheckedCast(data));
  }

  @JsOverlay
  public final void send(ArrayBufferView data) {
    send(Js.<SendDataUnionType>uncheckedCast(data));
  }

  @JsOverlay
  public final void send(Blob data) {
    send(Js.<SendDataUnionType>uncheckedCast(data));
  }

  @JsOverlay
  public final void send(Document data) {
    send(Js.<SendDataUnionType>uncheckedCast(data));
  }

  @JsOverlay
  public final void send(FormData data) {
    send(Js.<SendDataUnionType>uncheckedCast(data));
  }

  public native void send(SendDataUnionType data);

  @JsOverlay
  public final void send(String data) {
    send(Js.<SendDataUnionType>uncheckedCast(data));
  }

  public native void setRequestHeader(String header, String value);
}
