/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.tri;

import java.util.Objects;
import java.util.function.Function;
import org.drools.model.Variable;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractGroupBy;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractGroupByAccumulator;
import org.optaplanner.core.impl.score.stream.drools.common.TriTuple;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriToBiGroupBy;
import org.optaplanner.core.impl.score.stream.tri.DefaultTriConstraintCollector;

public class DroolsTriToBiGroupByAccumulator<A, B, C, NewA, NewB>
extends DroolsAbstractGroupByAccumulator<TriTuple<A, B, C>> {
    private final TriFunction<A, B, C, NewA> groupKeyMapping;
    private final TriConstraintCollector<A, B, C, ?, NewB> collector;
    private final Variable<A> aVariable;
    private final Variable<B> bVariable;
    private final Variable<C> cVariable;

    public DroolsTriToBiGroupByAccumulator(TriFunction<A, B, C, NewA> groupKeyMapping, TriConstraintCollector<A, B, C, ?, NewB> collector, Variable<A> aVariable, Variable<B> bVariable, Variable<C> cVariable) {
        this.groupKeyMapping = Objects.requireNonNull(groupKeyMapping);
        this.collector = collector != null ? collector : DefaultTriConstraintCollector.noop();
        this.aVariable = Objects.requireNonNull(aVariable);
        this.bVariable = Objects.requireNonNull(bVariable);
        this.cVariable = Objects.requireNonNull(cVariable);
    }

    @Override
    protected DroolsAbstractGroupBy<TriTuple<A, B, C>, ?> newContext() {
        return new DroolsTriToBiGroupBy<A, B, C, NewA, NewB>(this.groupKeyMapping, this.collector);
    }

    @Override
    protected <X> TriTuple<A, B, C> createInput(Function<Variable<X>, X> valueFinder) {
        A a = DroolsTriToBiGroupByAccumulator.materialize(this.aVariable, valueFinder);
        B b = DroolsTriToBiGroupByAccumulator.materialize(this.bVariable, valueFinder);
        C c = DroolsTriToBiGroupByAccumulator.materialize(this.cVariable, valueFinder);
        return new TriTuple<A, B, C>(a, b, c);
    }
}

