/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.workbench.client.admin;

import java.util.HashMap;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.soup.commons.util.Sets;
import org.kie.workbench.common.profile.api.preferences.ProfileService;
import org.kie.workbench.common.widgets.client.handlers.workbench.configuration.LanguageConfigurationHandler;
import org.kie.workbench.common.widgets.client.handlers.workbench.configuration.WorkbenchConfigurationHandler;
import org.kie.workbench.common.widgets.client.handlers.workbench.configuration.WorkbenchConfigurationPresenter;
import org.kie.workbench.common.workbench.client.resources.i18n.DefaultWorkbenchConstants;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.experimental.client.service.ClientExperimentalFeaturesRegistryService;
import org.uberfire.ext.preferences.client.admin.page.AdminPage;
import org.uberfire.ext.preferences.client.admin.page.AdminPageOptions;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.impl.SearchRequestImpl;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.preferences.shared.PreferenceScopeFactory;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;

public class DefaultAdminPageHelper {
    DefaultWorkbenchConstants constants = DefaultWorkbenchConstants.INSTANCE;
    @Inject
    private AdminPage adminPage;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private ClientUserSystemManager userSystemManager;
    @Inject
    private TranslationService translationService;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private PreferenceScopeFactory scopeFactory;
    @Inject
    private UberfireBreadcrumbs breadcrumbs;
    @Inject
    private WorkbenchConfigurationPresenter workbenchConfigurationPresenter;
    @Inject
    private LanguageConfigurationHandler languageConfigurationHandler;
    @Inject
    private ClientExperimentalFeaturesRegistryService experimentalFeaturesService;
    @Inject
    Caller<ProfileService> profileService;
    private static final String ADVANCED_CATEGORY = "advanced";

    public void setup() {
        this.setup(true, true, true);
    }

    public void setup(boolean libraryPreferencesEnabled, boolean artifactRepositoryPreferencesEnabled, boolean stunnerEnabled) {
        this.adminPage.addScreen("root", this.constants.Settings());
        this.adminPage.setDefaultScreen("root");
        this.addSecurityPerspective();
        this.addArtifactsPerspective();
        this.addDataSourcePerspective();
        this.addDataSetPerspective();
        this.addGlobalPreferences(libraryPreferencesEnabled, artifactRepositoryPreferencesEnabled);
        this.addGeneralPreferences();
        this.addStunnerPreferences(stunnerEnabled);
        this.addExperimentalPreferences();
        this.addSSHKeys();
        this.addProfilePreferences();
        this.addDataTransferPerspective();
        if (libraryPreferencesEnabled) {
            this.addArchetypesPerspective();
        }
    }

    private void addDataTransferPerspective() {
        boolean authorized = this.authorizationManager.authorize("datatransfer.access", this.sessionInfo.getIdentity());
        if (!authorized) {
            return;
        }
        this.adminPage.addTool("root", this.constants.DataTransfer(), new Sets.Builder().add((Object)"pficon").add((Object)"pficon-import").build(), "services", () -> {
            Command cmd = () -> this.placeManager.goTo("DataTransferPerspective");
            cmd.execute();
            this.addAdminBreadcrumbs("DataTransferPerspective", this.constants.DataTransfer(), cmd);
        });
    }

    private void addProfilePreferences() {
        boolean canEditProfilePreferences = this.authorizationManager.authorize("profilepreferences.edit", this.sessionInfo.getIdentity());
        ((ProfileService)this.profileService.call(force -> {
            if (canEditProfilePreferences && !force.booleanValue()) {
                this.adminPage.addPreference("root", "ProfilePreferences", this.translationService.format("ProfilePreferences.Title", new Object[0]), new Sets.Builder().add((Object)"fa").add((Object)"fa-list").build(), ADVANCED_CATEGORY, this.scopeFactory.createScope("global"), new AdminPageOptions[]{AdminPageOptions.WITH_BREADCRUMBS});
            }
        })).isForce();
    }

    private void addGeneralPreferences() {
        this.adminPage.addTool("root", this.constants.Languages(), new Sets.Builder().add((Object)"fa").add((Object)"fa-language").build(), "preferences", () -> this.workbenchConfigurationPresenter.show((WorkbenchConfigurationHandler)this.languageConfigurationHandler));
    }

    private void addStunnerPreferences(boolean stunnerEnabled) {
        if (stunnerEnabled) {
            this.adminPage.addPreference("root", "StunnerPreferences", this.constants.StunnerDesignerPreferences(), new Sets.Builder().add((Object)"fa").add((Object)"fa-object-group").build(), "general", this.scopeFactory.createScope("global"), new AdminPageOptions[]{AdminPageOptions.WITH_BREADCRUMBS});
        }
    }

    private void addExperimentalPreferences() {
        if (this.hasAccessToPerspective("ExperimentalFeaturesPerspective") && this.experimentalFeaturesService.isExperimentalEnabled().booleanValue() && !this.experimentalFeaturesService.getFeaturesRegistry().getAllFeatures().isEmpty()) {
            this.adminPage.addTool("root", this.constants.ExperimentalSettings(), new Sets.Builder().add((Object)"fa").add((Object)"fa-flask").build(), ADVANCED_CATEGORY, () -> {
                Command accessExperimentals = () -> this.placeManager.goTo("ExperimentalFeaturesPerspective");
                accessExperimentals.execute();
                this.addAdminBreadcrumbs("ExperimentalFeaturesPerspective", this.constants.ExperimentalSettings(), accessExperimentals);
            });
        }
    }

    private void addSSHKeys() {
        this.adminPage.addTool("root", this.constants.SSHKeys(), new Sets.Builder().add((Object)"fa").add((Object)"fa-key").build(), "general", () -> {
            Command accessSSHKeysEditor = () -> this.placeManager.goTo("SSHKeysEditorPerspective");
            accessSSHKeysEditor.execute();
            this.addAdminBreadcrumbs("SSHKeysEditorPerspective", this.constants.SSHKeys(), accessSSHKeysEditor);
        });
    }

    private void addSecurityPerspective() {
        if (this.hasAccessToPerspective("SecurityManagementPerspective")) {
            this.adminPage.addTool("root", this.constants.Roles(), new Sets.Builder().add((Object)"fa").add((Object)"fa-unlock-alt").build(), "security", () -> {
                Command accessRoles = () -> {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("activeTab", "RolesTab");
                    this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("SecurityManagementPerspective", params));
                };
                accessRoles.execute();
                this.addAdminBreadcrumbs("SecurityManagementPerspective", this.constants.SecurityManagement(), accessRoles);
            }, command -> this.userSystemManager.roles(response -> {
                if (response != null) {
                    command.execute((Object)response.getTotal());
                }
            }, (o, throwable) -> false).search((AbstractEntityManager.SearchRequest)new SearchRequestImpl("", 1, 1, null)));
            this.adminPage.addTool("root", this.constants.Groups(), new Sets.Builder().add((Object)"fa").add((Object)"fa-users").build(), "security", () -> {
                Command accessGroups = () -> {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("activeTab", "GroupsTab");
                    this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("SecurityManagementPerspective", params));
                };
                accessGroups.execute();
                this.addAdminBreadcrumbs("SecurityManagementPerspective", this.constants.SecurityManagement(), accessGroups);
            }, command -> this.userSystemManager.groups(response -> {
                if (response != null) {
                    command.execute((Object)response.getTotal());
                }
            }, (o, throwable) -> false).search((AbstractEntityManager.SearchRequest)new SearchRequestImpl("", 1, 1, null)));
            this.adminPage.addTool("root", this.constants.Users(), new Sets.Builder().add((Object)"fa").add((Object)"fa-user").build(), "security", () -> {
                Command accessUsers = () -> {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("activeTab", "UsersTab");
                    this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("SecurityManagementPerspective", params));
                };
                accessUsers.execute();
                this.addAdminBreadcrumbs("SecurityManagementPerspective", this.constants.SecurityManagement(), accessUsers);
            }, command -> this.userSystemManager.users(response -> {
                if (response != null) {
                    command.execute((Object)response.getTotal());
                }
            }, (o, throwable) -> false).search((AbstractEntityManager.SearchRequest)new SearchRequestImpl("", 1, 1, null)));
        }
    }

    private void addArtifactsPerspective() {
        if (this.hasAccessToPerspective("GuvnorM2RepoPerspective")) {
            this.adminPage.addTool("root", this.constants.Artifacts(), new Sets.Builder().add((Object)"fa").add((Object)"fa-download").build(), "perspectives", () -> {
                Command accessArtifacts = () -> this.placeManager.goTo("GuvnorM2RepoPerspective");
                accessArtifacts.execute();
                this.addAdminBreadcrumbs("GuvnorM2RepoPerspective", this.constants.Artifacts(), accessArtifacts);
            });
        }
    }

    private void addDataSourcePerspective() {
        if (this.hasAccessToPerspective("DataSourceManagementPerspective")) {
            this.adminPage.addTool("root", this.constants.DataSources(), new Sets.Builder().add((Object)"fa").add((Object)"fa-database").build(), "perspectives", () -> {
                Command accessDataSources = () -> this.placeManager.goTo("DataSourceManagementPerspective");
                accessDataSources.execute();
                this.addAdminBreadcrumbs("DataSourceManagementPerspective", this.constants.DataSources(), accessDataSources);
            });
        }
    }

    private void addDataSetPerspective() {
        if (this.hasAccessToPerspective("DataSetAuthoringPerspective")) {
            this.adminPage.addTool("root", this.constants.DataSets(), new Sets.Builder().add((Object)"fa").add((Object)"fa-folder-open").build(), "perspectives", () -> {
                Command accessDataSets = () -> this.placeManager.goTo("DataSetAuthoringPerspective");
                accessDataSets.execute();
                this.addAdminBreadcrumbs("DataSetAuthoringPerspective", this.constants.DataSets(), accessDataSets);
            });
        }
    }

    private void addArchetypesPerspective() {
        if (this.hasAccessToPerspective("ArchetypeManagementPerspective")) {
            this.adminPage.addTool("root", this.constants.Archetypes(), new Sets.Builder().add((Object)"fa").add((Object)"fa-file-code-o").build(), ADVANCED_CATEGORY, () -> {
                Command accessArchetypeMgmt = () -> this.placeManager.goTo("ArchetypeManagementPerspective");
                accessArchetypeMgmt.execute();
                this.addAdminBreadcrumbs("ArchetypeManagementPerspective", this.constants.Archetypes(), accessArchetypeMgmt);
            });
        }
    }

    private void addGlobalPreferences(boolean libraryPreferencesEnabled, boolean artifactRepositoryPreferencesEnabled) {
        boolean canEditGlobalPreferences = this.authorizationManager.authorize("globalpreferences.edit", this.sessionInfo.getIdentity());
        if (!canEditGlobalPreferences) {
            return;
        }
        if (libraryPreferencesEnabled) {
            this.adminPage.addPreference("root", "LibraryPreferences", this.translationService.format("LibraryPreferences.Title", new Object[0]), new Sets.Builder().add((Object)"fa").add((Object)"fa-cubes").build(), "preferences", this.scopeFactory.createScope("global"), new AdminPageOptions[]{AdminPageOptions.WITH_BREADCRUMBS});
        }
        if (artifactRepositoryPreferencesEnabled) {
            this.adminPage.addPreference("root", "ArtifactRepositoryPreference", this.translationService.format("ArtifactRepositoryPreferences.Title", new Object[0]), new Sets.Builder().add((Object)"fa").add((Object)"fa-archive").build(), "preferences", this.scopeFactory.createScope("global"), new AdminPageOptions[]{AdminPageOptions.WITH_BREADCRUMBS});
        }
        this.adminPage.addPreference("root", "ManagePreferences", this.constants.ProcessAdministration(), new Sets.Builder().add((Object)"pficon").add((Object)"pficon-storage-domain").build(), "general", this.scopeFactory.createScope("global"), new AdminPageOptions[]{AdminPageOptions.WITH_BREADCRUMBS});
        this.adminPage.addTool("root", this.constants.ServiceTasksAdministration(), new Sets.Builder().add((Object)"fa").add((Object)"fa-cogs").build(), "services", () -> {
            Command accessServiceTasks = () -> this.placeManager.goTo("ServiceTaskAdminPerspective");
            accessServiceTasks.execute();
            this.addAdminBreadcrumbs("ServiceTaskAdminPerspective", this.constants.ServiceTasksAdministration(), accessServiceTasks);
        });
    }

    private void addAdminBreadcrumbs(String perspective, String label, Command accessCommand) {
        this.breadcrumbs.clearBreadcrumbs(perspective);
        this.breadcrumbs.addBreadCrumb(perspective, this.constants.Admin(), (PlaceRequest)new DefaultPlaceRequest("AdminPagePerspective"), () -> this.placeManager.goTo("AdminPagePerspective"));
        this.breadcrumbs.addBreadCrumb(perspective, label, accessCommand);
    }

    boolean hasAccessToPerspective(String perspectiveId) {
        ResourceRef resourceRef = new ResourceRef(perspectiveId, (ResourceType)ActivityResourceType.PERSPECTIVE);
        return this.authorizationManager.authorize((Resource)resourceRef, this.sessionInfo.getIdentity());
    }
}

