/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.downloadreport;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.drools.scenariosimulation.api.model.AuditLog;
import org.drools.scenariosimulation.api.model.AuditLogLine;

public class ScenarioCsvDownloadReport {
    public String getReport(AuditLog auditLog) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CSVPrinter printer = new CSVPrinter((Appendable)stringBuilder, CSVFormat.DEFAULT);
        this.generateHeader(printer);
        for (AuditLogLine auditLogLine : auditLog.getAuditLogLines()) {
            this.printAuditLogLine(auditLogLine, printer);
        }
        printer.close();
        return stringBuilder.toString();
    }

    protected void printAuditLogLine(AuditLogLine toPrint, CSVPrinter printer) throws IOException {
        printer.print((Object)toPrint.getScenarioIndex());
        printer.print((Object)toPrint.getScenario());
        printer.print((Object)toPrint.getExecutionIndex());
        printer.print((Object)toPrint.getMessage());
        printer.print((Object)toPrint.getLevel());
        printer.println();
    }

    protected void generateHeader(CSVPrinter printer) throws IOException {
        printer.printRecord(Arrays.asList("Scenario index", "Scenario", "Result index", "Result", "Level"));
    }
}

