/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import org.drools.scenariosimulation.backend.runner.ScenarioException;

public class IndexedScenarioException
extends ScenarioException {
    private final int index;
    private String fileName;

    public IndexedScenarioException(int index, String message) {
        super(message);
        this.index = index;
    }

    public IndexedScenarioException(int index, String message, Throwable cause) {
        super(message, cause);
        this.index = index;
    }

    public IndexedScenarioException(int index, Throwable cause) {
        super(cause);
        this.index = index;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getMessage() {
        String errorMessage = this.getCause() != null ? this.getCause().getMessage() : super.getMessage();
        StringBuilder message = new StringBuilder().append("#").append(this.index).append(": ").append(errorMessage);
        if (this.getFileName() != null) {
            message.append("(").append(this.getFileName()).append(")");
        }
        return message.toString();
    }
}

