/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.util;

import java.util.Arrays;

public class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(String s) {
        return null == s || s.trim().length() == 0;
    }

    public static boolean nonEmpty(String s) {
        return !StringUtils.isEmpty(s);
    }

    public static boolean hasNonEmpty(String ... values) {
        return values != null && Arrays.stream(values).anyMatch(StringUtils::nonEmpty);
    }

    public static boolean isQuoted(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        return str.startsWith("\"") && str.endsWith("\"");
    }

    public static String createQuotedString(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        return "\"" + str + "\"";
    }

    public static String createQuotedStringIfNotNumeric(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return "\"" + str + "\"";
        }
        return str;
    }

    public static String replaceIllegalCharsAttribute(String value) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String revertIllegalCharsAttribute(String value) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        return value.replace("&lt;", "<").replace("&gt;", ">").replace("&amp;", "&").replace("&quot;", "\"");
    }

    public static String createUnquotedString(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (str.startsWith("\"")) {
            str = str.substring(1);
        }
        if (str.endsWith("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

