/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowElement;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.BPMNElementDecorators;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNBaseInfo;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessageDecorator;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BPMNElementDecoratorsTest {
    private static final String NAME = "NAME";

    @Test
    public void flowElementDecorator() {
        MarshallingMessageDecorator decorator = BPMNElementDecorators.flowElementDecorator();
        FlowElement element = (FlowElement)Mockito.mock(FlowElement.class);
        Mockito.when((Object)element.getName()).thenReturn((Object)NAME);
        Assert.assertEquals((Object)NAME, (Object)decorator.getName((Object)element));
        Assert.assertEquals((Object)element.getClass().getSimpleName(), (Object)decorator.getType((Object)element));
    }

    @Test
    public void baseElementDecorator() {
        MarshallingMessageDecorator decorator = BPMNElementDecorators.baseElementDecorator();
        BaseElement element = (BaseElement)Mockito.mock(FlowElement.class);
        Mockito.when((Object)element.getId()).thenReturn((Object)NAME);
        Assert.assertEquals((Object)NAME, (Object)decorator.getName((Object)element));
        Assert.assertEquals((Object)element.getClass().getSimpleName(), (Object)decorator.getType((Object)element));
    }

    @Test
    public void bpmnNodeDecorator() {
        MarshallingMessageDecorator decorator = BPMNElementDecorators.bpmnNodeDecorator();
        BpmnNode element = this.mockBpmnNode();
        Assert.assertEquals((Object)NAME, (Object)decorator.getName((Object)element));
        Assert.assertEquals((Object)((BPMNViewDefinition)((View)element.value().getContent()).getDefinition()).getClass().getSimpleName(), (Object)decorator.getType((Object)element));
    }

    private BpmnNode mockBpmnNode() {
        BpmnNode element = (BpmnNode)Mockito.mock(BpmnNode.class);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)element.value()).thenReturn((Object)node);
        View content = (View)Mockito.mock(View.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)content);
        BPMNViewDefinition viewDefinition = (BPMNViewDefinition)Mockito.mock(BPMNViewDefinition.class);
        Mockito.when((Object)content.getDefinition()).thenReturn((Object)viewDefinition);
        BPMNBaseInfo general = (BPMNBaseInfo)Mockito.mock(BPMNBaseInfo.class);
        Mockito.when((Object)viewDefinition.getGeneral()).thenReturn((Object)general);
        Name name = (Name)Mockito.mock(Name.class);
        Mockito.when((Object)general.getName()).thenReturn((Object)name);
        Mockito.when((Object)name.getValue()).thenReturn((Object)NAME);
        return element;
    }

    @Test
    public void resultBpmnDecorator() {
        MarshallingMessageDecorator decorator = BPMNElementDecorators.resultBpmnDecorator();
        BpmnNode node = this.mockBpmnNode();
        Result result = Result.success((Object)node, (MarshallingMessage[])new MarshallingMessage[0]);
        Assert.assertEquals((Object)NAME, (Object)decorator.getName((Object)result));
        Assert.assertEquals((Object)((BPMNViewDefinition)((View)node.value().getContent()).getDefinition()).getClass().getSimpleName(), (Object)decorator.getType((Object)result));
    }
}

