/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend.definition.adapter.reflect;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.AbstractReflectAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionId;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.HasInheritance;
import org.kie.workbench.common.stunner.core.definition.annotation.Definition;
import org.kie.workbench.common.stunner.core.definition.annotation.Description;
import org.kie.workbench.common.stunner.core.definition.annotation.Property;
import org.kie.workbench.common.stunner.core.definition.annotation.PropertySet;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Category;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Id;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Labels;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Title;
import org.kie.workbench.common.stunner.core.definition.property.PropertyMetaTypes;
import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class BackendDefinitionAdapter<T>
extends AbstractReflectAdapter<T>
implements DefinitionAdapter<T>,
HasInheritance {
    private static final Logger LOG = LoggerFactory.getLogger(BackendDefinitionAdapter.class);
    private static final Class[] DEF_ANNOTATIONS = new Class[]{Title.class, Category.class, Description.class, PropertySet.class, Property.class};
    private final DefinitionUtils definitionUtils;

    @Inject
    public BackendDefinitionAdapter(DefinitionUtils definitionUtils) {
        this.definitionUtils = definitionUtils;
    }

    public boolean accepts(Class<?> pojo) {
        return pojo.getAnnotation(Definition.class) != null;
    }

    public DefinitionId getId(T definition) {
        String definitionId = this.getDefinitionId(definition.getClass());
        Id idAnn = BackendDefinitionAdapter.getClassAnnotation(definition.getClass(), Id.class);
        if (null != idAnn) {
            try {
                String value = BindableAdapterUtils.getDynamicDefinitionId((String)definitionId, (String)((String)this.getAnnotatedFieldValue(definition, Id.class)));
                return DefinitionId.build((String)value, (int)definitionId.length());
            }
            catch (Exception e) {
                LOG.error("Error obtaining annotated id for Definition " + definition.getClass().getName());
            }
        }
        return DefinitionId.build((String)definitionId);
    }

    public Object getMetaProperty(PropertyMetaTypes metaType, T pojo) {
        Set<?> properties = this.getProperties(pojo);
        if (null != properties) {
            return properties.stream().filter(property -> {
                Property p = BackendDefinitionAdapter.getClassAnnotation(property.getClass(), Property.class);
                return null != p && metaType.equals((Object)p.meta());
            }).findFirst().orElse(null);
        }
        return null;
    }

    public String getCategory(T definition) {
        try {
            return (String)this.getAnnotatedFieldValue(definition, Category.class);
        }
        catch (Exception e) {
            LOG.error("Error obtaining annotated category for Definition with id " + this.getId(definition));
            return null;
        }
    }

    public String getTitle(T definition) {
        try {
            return (String)this.getAnnotatedFieldValue(definition, Title.class);
        }
        catch (Exception e) {
            LOG.error("Error obtaining annotated title for Definition with id " + this.getId(definition));
            return BindableAdapterUtils.toSimpleName(definition);
        }
    }

    public Optional<String> getNameField(T definition) {
        return Optional.ofNullable(BackendDefinitionAdapter.getDefinitionAnnotation(definition.getClass())).map(Definition::nameField);
    }

    public String getDescription(T definition) {
        try {
            return (String)this.getAnnotatedFieldValue(definition, Description.class);
        }
        catch (Exception e) {
            LOG.error("Error obtaining annotated description for Definition with id " + this.getId(definition));
            return BindableAdapterUtils.toSimpleName(definition);
        }
    }

    public Set<String> getLabels(T definition) {
        try {
            return (Set)this.getAnnotatedFieldValue(definition, Labels.class);
        }
        catch (Exception e) {
            LOG.error("Error obtaining annotated labels for Definition with id " + this.getId(definition));
            return Collections.emptySet();
        }
    }

    public Set<?> getPropertySets(T definition) {
        Collection<Field> fields = BackendDefinitionAdapter.getFieldAnnotations(definition.getClass(), PropertySet.class);
        if (null != fields) {
            LinkedHashSet result = new LinkedHashSet();
            fields.forEach(field -> {
                try {
                    Object v = this._getValue((Field)field, PropertySet.class, definition);
                    result.add(v);
                }
                catch (Exception e) {
                    LOG.error("Error obtaining annotated property sets for Definition with id " + this.getId(definition));
                }
            });
            return result;
        }
        return Collections.emptySet();
    }

    public Set<?> getProperties(T definition) {
        if (null != definition) {
            Collection<Field> fields;
            HashSet result = new HashSet();
            Set propertySetProperties = this.definitionUtils.getPropertiesFromPropertySets(definition);
            if (null != propertySetProperties) {
                result.addAll(propertySetProperties);
            }
            if (null != (fields = BackendDefinitionAdapter.getFieldAnnotations(definition.getClass(), Property.class))) {
                fields.forEach(field -> {
                    try {
                        Object v = this._getValue((Field)field, Property.class, definition);
                        result.add(v);
                    }
                    catch (Exception e) {
                        LOG.error("Error obtaining annotated properties for Definition with id " + this.getId(definition));
                    }
                });
                return result;
            }
        }
        return Collections.emptySet();
    }

    private <V> V _getValue(Field field, Object annotation, T definition) throws IllegalAccessException {
        if (null != annotation) {
            field.setAccessible(true);
            return (V)field.get(definition);
        }
        return null;
    }

    public Class<? extends ElementFactory> getGraphFactoryType(T definition) {
        Definition annotation = BackendDefinitionAdapter.getDefinitionAnnotation(definition.getClass());
        return null != annotation ? annotation.graphFactory() : null;
    }

    public static Class<? extends ElementFactory> getGraphFactory(Class<?> type) {
        Definition annotation = BackendDefinitionAdapter.getDefinitionAnnotation(type);
        return null != annotation ? annotation.graphFactory() : null;
    }

    protected static Definition getDefinitionAnnotation(Class<?> type) {
        Definition annotation;
        if (null != type && null != (annotation = BackendDefinitionAdapter.getClassAnnotation(type, Definition.class))) {
            return annotation;
        }
        return null;
    }

    public String getBaseType(Class<?> type) {
        return Optional.ofNullable(type).filter(t -> !t.isPrimitive()).filter(t -> Objects.nonNull(BackendDefinitionAdapter.getClassAnnotation(t, Definition.class))).map(this::findBaseParent).map(this::getDefinitionId).orElse(null);
    }

    private Class findBaseParent(Class type) {
        return Objects.isNull(type) || Object.class.equals((Object)type) ? null : Optional.ofNullable(type).map(Class::getSuperclass).filter(this::isBaseType).orElse(this.findBaseParent(type.getSuperclass()));
    }

    public String[] getTypes(String baseType) {
        throw new UnsupportedOperationException("Not implemented yet. Must keep some collection for this. ");
    }

    private boolean isBaseType(Class<?> type) {
        Field[] fields = type.getDeclaredFields();
        if (null != fields) {
            for (Field field : fields) {
                for (Class a : DEF_ANNOTATIONS) {
                    Object annotation = field.getAnnotation(a);
                    if (null == annotation) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

