/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.solver;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.Objects;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactory;
import org.optaplanner.core.impl.solver.DefaultSolverFactory;

public abstract class SolverFactory<Solution_> {
    public static <Solution_> SolverFactory<Solution_> createFromXmlResource(String solverConfigResource) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource(solverConfigResource);
        return new DefaultSolverFactory(solverConfig);
    }

    public static <Solution_> SolverFactory<Solution_> createFromXmlResource(String solverConfigResource, ClassLoader classLoader) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource(solverConfigResource, classLoader);
        return new DefaultSolverFactory(solverConfig);
    }

    public static <Solution_> SolverFactory<Solution_> createFromXmlFile(File solverConfigFile) {
        SolverConfig solverConfig = SolverConfig.createFromXmlFile(solverConfigFile);
        return new DefaultSolverFactory(solverConfig);
    }

    public static <Solution_> SolverFactory<Solution_> createFromXmlFile(File solverConfigFile, ClassLoader classLoader) {
        SolverConfig solverConfig = SolverConfig.createFromXmlFile(solverConfigFile, classLoader);
        return new DefaultSolverFactory(solverConfig);
    }

    @Deprecated
    public static <Solution_> SolverFactory<Solution_> createFromXmlInputStream(InputStream in) {
        SolverConfig solverConfig = SolverConfig.createFromXmlInputStream(in);
        return new DefaultSolverFactory(solverConfig);
    }

    @Deprecated
    public static <Solution_> SolverFactory<Solution_> createFromXmlInputStream(InputStream in, ClassLoader classLoader) {
        SolverConfig solverConfig = SolverConfig.createFromXmlInputStream(in, classLoader);
        return new DefaultSolverFactory(solverConfig);
    }

    @Deprecated
    public static <Solution_> SolverFactory<Solution_> createFromXmlReader(Reader reader) {
        SolverConfig solverConfig = SolverConfig.createFromXmlReader(reader);
        return new DefaultSolverFactory(solverConfig);
    }

    @Deprecated
    public static <Solution_> SolverFactory<Solution_> createFromXmlReader(Reader reader, ClassLoader classLoader) {
        SolverConfig solverConfig = SolverConfig.createFromXmlReader(reader, classLoader);
        return new DefaultSolverFactory(solverConfig);
    }

    public static <Solution_> SolverFactory<Solution_> create(SolverConfig solverConfig) {
        Objects.requireNonNull(solverConfig);
        solverConfig = new SolverConfig(solverConfig);
        return new DefaultSolverFactory(solverConfig);
    }

    @Deprecated
    public static <Solution_> SolverFactory<Solution_> createEmpty() {
        return new DefaultSolverFactory(new SolverConfig());
    }

    @Deprecated
    public static <Solution_> SolverFactory<Solution_> createEmpty(ClassLoader classLoader) {
        return new DefaultSolverFactory(new SolverConfig(classLoader));
    }

    public static <Solution_> SolverFactory<Solution_> createFromKieContainerXmlResource(String solverConfigResource) {
        KieContainer kieContainer = KieServices.Factory.get().getKieClasspathContainer();
        return SolverFactory.createFromKieContainerXmlResource(kieContainer, solverConfigResource);
    }

    public static <Solution_> SolverFactory<Solution_> createFromKieContainerXmlResource(ReleaseId releaseId, String solverConfigResource) {
        KieContainer kieContainer = KieServices.Factory.get().newKieContainer(releaseId);
        return SolverFactory.createFromKieContainerXmlResource(kieContainer, solverConfigResource);
    }

    public static <Solution_> SolverFactory<Solution_> createFromKieContainerXmlResource(KieContainer kieContainer, String solverConfigResource) {
        SolverConfig solverConfig = SolverConfig.createFromXmlResource(solverConfigResource, kieContainer.getClassLoader());
        return new DefaultSolverFactory(solverConfig, new SolverConfigContext(kieContainer));
    }

    public static <Solution_> SolverFactory<Solution_> createEmptyFromKieContainer(ReleaseId releaseId) {
        KieContainer kieContainer = KieServices.Factory.get().newKieContainer(releaseId);
        return SolverFactory.createEmptyFromKieContainer(kieContainer);
    }

    public static <Solution_> SolverFactory<Solution_> createEmptyFromKieContainer(KieContainer kieContainer) {
        SolverConfig solverConfig = new SolverConfig(kieContainer.getClassLoader());
        return new DefaultSolverFactory(solverConfig, new SolverConfigContext(kieContainer));
    }

    public abstract Solver<Solution_> buildSolver();

    public abstract ScoreDirectorFactory<Solution_> getScoreDirectorFactory();

    @Deprecated
    public abstract SolverConfig getSolverConfig();

    @Deprecated
    public abstract SolverFactory<Solution_> cloneSolverFactory();
}

