/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.backend.service;

import java.util.Map;
import java.util.Optional;
import javax.enterprise.inject.Instance;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.kie.workbench.common.services.backend.service.KieServiceOverviewLoader;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.backend.service.AbstractVFSDiagramService;
import org.kie.workbench.common.stunner.core.definition.service.DefinitionSetService;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.registry.BackendRegistryFactory;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.stunner.project.diagram.impl.ProjectMetadataImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardDeleteOption;

class ProjectDiagramServiceController
extends AbstractVFSDiagramService<ProjectMetadata, ProjectDiagram> {
    private static final Logger LOG = LoggerFactory.getLogger((String)ProjectDiagramServiceController.class.getName());
    private final IOService ioService;
    private final KieModuleService moduleService;
    private final KieServiceOverviewLoader overviewLoader;

    ProjectDiagramServiceController(DefinitionManager definitionManager, FactoryManager factoryManager, Instance<DefinitionSetService> definitionSetServiceInstances, IOService ioService, BackendRegistryFactory registryFactory, KieModuleService moduleService, KieServiceOverviewLoader overviewLoader) {
        super(definitionManager, factoryManager, definitionSetServiceInstances, registryFactory);
        this.ioService = ioService;
        this.moduleService = moduleService;
        this.overviewLoader = overviewLoader;
    }

    protected void initialize() {
        super.initialize();
    }

    protected Class<? extends Metadata> getMetadataType() {
        return ProjectMetadata.class;
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path path, String name, String defSetId) {
        return this.create(path, name, defSetId, this.getCurrentModule(path).getModuleName(), null, Optional.empty());
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path path, String name, String defSetId, String moduleName, Package projectPkg, Optional<String> projectType) {
        ProjectMetadata metadata = this.buildProjectMetadataInstance(path, name, defSetId, moduleName, projectPkg, this.overviewLoader.loadOverview(path), projectType);
        return this.create(path, name, defSetId, (Metadata)metadata);
    }

    public ProjectDiagram getDiagramByPath(org.uberfire.backend.vfs.Path file) {
        ProjectDiagram projectDiagram = (ProjectDiagram)super.getDiagramByPath(file);
        Path svgPath = this.getDiagramSvgFilePath((Diagram)projectDiagram);
        if (this.getIoService().exists(svgPath)) {
            ((ProjectMetadata)projectDiagram.getMetadata()).setDiagramSVGPath(Paths.convert((Path)svgPath));
            String svgContent = this.getIoService().readAllString(svgPath);
            if (svgContent != null && svgContent.contains("xmlns:oryx=\"http://oryx-editor.org\"")) {
                ((ProjectMetadata)projectDiagram.getMetadata()).setDiagramSVGGenerator(ProjectMetadata.SVGGenerator.JBPM_DESIGNER);
            } else {
                ((ProjectMetadata)projectDiagram.getMetadata()).setDiagramSVGGenerator(ProjectMetadata.SVGGenerator.STUNNER);
            }
        }
        return projectDiagram;
    }

    protected Metadata buildMetadataInstance(org.uberfire.backend.vfs.Path path, String defSetId, String title) {
        Package modulePackage = this.moduleService.resolvePackage(path);
        KieModule kieModule = this.getCurrentModule(path);
        return this.buildProjectMetadataInstance(path, title, defSetId, kieModule.getModuleName(), modulePackage, this.overviewLoader.loadOverview(path), Optional.empty());
    }

    private KieModule getCurrentModule(org.uberfire.backend.vfs.Path path) {
        return (KieModule)this.moduleService.resolveModule(path);
    }

    private ProjectMetadata buildProjectMetadataInstance(org.uberfire.backend.vfs.Path path, String name, String defSetId, String moduleName, Package projPkg, Overview overview, Optional<String> projectType) {
        return new ProjectMetadataImpl.ProjectMetadataBuilder().forDefinitionSetId(defSetId).forModuleName(moduleName).forProjectPackage(projPkg).forOverview(overview).forTitle(name).forPath(path).forProjectType((String)projectType.orElse(null)).build();
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, ProjectDiagram diagram, Map<String, ?> attributes, OpenOption ... comment) {
        try {
            String[] raw = this.serialize((Diagram)diagram);
            this.getIoService().write(Paths.convert((org.uberfire.backend.vfs.Path)path), raw[0], attributes, comment);
        }
        catch (Exception e) {
            LOG.error("Error while saving diagram with UUID [" + diagram.getName() + "].", (Throwable)e);
            throw new RuntimeException(e);
        }
        return path;
    }

    public org.uberfire.backend.vfs.Path saveAsXml(org.uberfire.backend.vfs.Path path, String xml, Map<String, ?> attributes, OpenOption ... comment) {
        try {
            this.getIoService().write(Paths.convert((org.uberfire.backend.vfs.Path)path), xml, attributes, comment);
        }
        catch (Exception e) {
            LOG.error("Error while saving diagram.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return path;
    }

    protected ProjectMetadata doSave(ProjectDiagram diagram, String raw, String metadata) {
        try {
            org.uberfire.backend.vfs.Path _path = ((ProjectMetadata)diagram.getMetadata()).getPath();
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)_path);
            if (!this.getIoService().exists(path)) {
                Path parent = path.getParent();
                String fileName = path.getFileName().toString();
                path = parent.resolve(fileName);
            }
            this.getIoService().write(path, raw, new OpenOption[0]);
        }
        catch (Exception e) {
            LOG.error("Error while saving diagram with UUID [" + diagram.getName() + "].", (Throwable)e);
            throw new RuntimeException(e);
        }
        return (ProjectMetadata)diagram.getMetadata();
    }

    public boolean delete(org.uberfire.backend.vfs.Path _path, String message) {
        Path path = Paths.convert((org.uberfire.backend.vfs.Path)_path);
        return this.getIoService().deleteIfExists(path, new DeleteOption[]{StandardDeleteOption.NON_EMPTY_DIRECTORIES});
    }

    protected boolean doDelete(org.uberfire.backend.vfs.Path path) {
        return this.delete(path, "");
    }

    protected IOService getIoService() {
        return this.ioService;
    }
}

