/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.ThreadLocalRandom;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.net.SocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RoundRobinDNSServerSet
extends ServerSet {
    static final String PROPERTY_DEFAULT_ADDRESSES = RoundRobinDNSServerSet.class.getName() + ".defaultAddresses";
    private final AddressSelectionMode selectionMode;
    private final AtomicLong roundRobinCounter;
    private final AtomicReference<ObjectPair<InetAddress[], Long>> resolvedAddressesWithTimeout;
    private final Hashtable<String, String> jndiProperties;
    private final int port;
    private final LDAPConnectionOptions connectionOptions;
    private final long cacheTimeoutMillis;
    private final SocketFactory socketFactory;
    private final String hostname;
    private final String providerURL;
    private final String[] dnsRecordTypes;

    public RoundRobinDNSServerSet(String hostname, int port, AddressSelectionMode selectionMode, long cacheTimeoutMillis, String providerURL, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions) {
        this(hostname, port, selectionMode, cacheTimeoutMillis, providerURL, null, null, socketFactory, connectionOptions);
    }

    public RoundRobinDNSServerSet(String hostname, int port, AddressSelectionMode selectionMode, long cacheTimeoutMillis, String providerURL, Properties jndiProperties, String[] dnsRecordTypes, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions) {
        Validator.ensureNotNull(hostname);
        Validator.ensureTrue(port >= 1 && port <= 65535);
        Validator.ensureNotNull((Object)selectionMode);
        this.hostname = hostname;
        this.port = port;
        this.selectionMode = selectionMode;
        this.providerURL = providerURL;
        if (jndiProperties == null) {
            if (providerURL == null) {
                this.jndiProperties = null;
            } else {
                this.jndiProperties = new Hashtable(2);
                this.jndiProperties.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
                this.jndiProperties.put("java.naming.provider.url", providerURL);
            }
        } else {
            this.jndiProperties = new Hashtable(jndiProperties.size() + 2);
            for (Map.Entry<Object, Object> e : jndiProperties.entrySet()) {
                this.jndiProperties.put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
            }
            if (!this.jndiProperties.containsKey("java.naming.factory.initial")) {
                this.jndiProperties.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            }
            if (!this.jndiProperties.containsKey("java.naming.provider.url") && providerURL != null) {
                this.jndiProperties.put("java.naming.provider.url", providerURL);
            }
        }
        this.dnsRecordTypes = dnsRecordTypes == null ? new String[]{"A"} : dnsRecordTypes;
        this.cacheTimeoutMillis = cacheTimeoutMillis > 0L ? cacheTimeoutMillis : 0L;
        this.socketFactory = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
        this.connectionOptions = connectionOptions == null ? new LDAPConnectionOptions() : connectionOptions;
        this.roundRobinCounter = new AtomicLong(0L);
        this.resolvedAddressesWithTimeout = new AtomicReference();
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public AddressSelectionMode getAddressSelectionMode() {
        return this.selectionMode;
    }

    public long getCacheTimeoutMillis() {
        return this.cacheTimeoutMillis;
    }

    public String getProviderURL() {
        return this.providerURL;
    }

    public Map<String, String> getJNDIProperties() {
        if (this.jndiProperties == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.jndiProperties);
    }

    public String[] getDNSRecordTypes() {
        return this.dnsRecordTypes;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public LDAPConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @Override
    public LDAPConnection getConnection() throws LDAPException {
        return this.getConnection(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized LDAPConnection getConnection(LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
        LDAPException firstException = null;
        LDAPConnection conn = new LDAPConnection(this.socketFactory, this.connectionOptions);
        for (InetAddress a : this.orderAddresses(this.resolveHostname())) {
            Object var9_9;
            boolean close = true;
            try {
                conn.connect(this.hostname, a, this.port, this.connectionOptions.getConnectTimeoutMillis());
                if (healthCheck != null) {
                    healthCheck.ensureNewConnectionValid(conn);
                }
                close = false;
                LDAPConnection lDAPConnection = conn;
                var9_9 = null;
                if (close) {
                    conn.close();
                }
                return lDAPConnection;
            }
            catch (LDAPException le) {
                try {
                    Debug.debugException(le);
                    if (firstException == null) {
                        firstException = le;
                    }
                    var9_9 = null;
                    if (!close) continue;
                    conn.close();
                }
                catch (Throwable throwable) {
                    var9_9 = null;
                    if (close) {
                        conn.close();
                    }
                    throw throwable;
                }
            }
        }
        throw firstException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InetAddress[] resolveHostname() throws LDAPException {
        InetAddress[] addresses;
        ObjectPair<InetAddress[], Long> pair;
        block12: {
            pair = this.resolvedAddressesWithTimeout.get();
            if (pair != null && pair.getSecond() <= System.currentTimeMillis()) {
                return pair.getFirst();
            }
            addresses = null;
            try {
                if (this.jndiProperties == null) {
                    addresses = InetAddress.getAllByName(this.hostname);
                    break block12;
                }
                Attributes attributes = null;
                InitialDirContext context = new InitialDirContext(this.jndiProperties);
                try {
                    attributes = context.getAttributes(this.hostname, this.dnsRecordTypes);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    context.close();
                    throw throwable;
                }
                context.close();
                if (attributes != null) {
                    ArrayList<InetAddress> addressList = new ArrayList<InetAddress>(10);
                    for (String recordType : this.dnsRecordTypes) {
                        Attribute a = attributes.get(recordType);
                        if (a == null) continue;
                        NamingEnumeration<?> values = a.getAll();
                        while (values.hasMore()) {
                            Object value = values.next();
                            addressList.add(this.getInetAddressForIP(String.valueOf(value)));
                        }
                    }
                    if (!addressList.isEmpty()) {
                        addresses = new InetAddress[addressList.size()];
                        addressList.toArray(addresses);
                    }
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                addresses = this.getDefaultAddresses();
            }
        }
        if (addresses != null && addresses.length > 0) {
            long timeoutTime = this.cacheTimeoutMillis > 0L ? System.currentTimeMillis() + this.cacheTimeoutMillis : System.currentTimeMillis() - 1L;
            this.resolvedAddressesWithTimeout.set(new ObjectPair<InetAddress[], Long>(addresses, timeoutTime));
            return addresses;
        }
        if (pair != null) {
            return pair.getFirst();
        }
        throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_ROUND_ROBIN_DNS_SERVER_SET_CANNOT_RESOLVE.get(this.hostname));
    }

    List<InetAddress> orderAddresses(InetAddress[] addresses) {
        ArrayList<InetAddress> l = new ArrayList<InetAddress>(addresses.length);
        switch (this.selectionMode) {
            case RANDOM: {
                l.addAll(Arrays.asList(addresses));
                Collections.shuffle(l, ThreadLocalRandom.get());
                break;
            }
            case ROUND_ROBIN: {
                int index;
                int i;
                for (i = index = (int)(this.roundRobinCounter.getAndIncrement() % (long)addresses.length); i < addresses.length; ++i) {
                    l.add(addresses[i]);
                }
                for (i = 0; i < index; ++i) {
                    l.add(addresses[i]);
                }
                break;
            }
            default: {
                l.addAll(Arrays.asList(addresses));
            }
        }
        return l;
    }

    InetAddress[] getDefaultAddresses() {
        String defaultAddrsStr = System.getProperty(PROPERTY_DEFAULT_ADDRESSES);
        if (defaultAddrsStr == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(defaultAddrsStr, " ,");
        InetAddress[] addresses = new InetAddress[tokenizer.countTokens()];
        for (int i = 0; i < addresses.length; ++i) {
            try {
                addresses[i] = this.getInetAddressForIP(tokenizer.nextToken());
                continue;
            }
            catch (Exception e) {
                Debug.debugException(e);
                return null;
            }
        }
        return addresses;
    }

    private InetAddress getInetAddressForIP(String ipAddress) throws UnknownHostException {
        InetAddress byName = InetAddress.getByName(String.valueOf(ipAddress));
        return InetAddress.getByAddress(this.hostname, byName.getAddress());
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("RoundRobinDNSServerSet(hostname='");
        buffer.append(this.hostname);
        buffer.append("', port=");
        buffer.append(this.port);
        buffer.append(", addressSelectionMode=");
        buffer.append(this.selectionMode.name());
        buffer.append(", cacheTimeoutMillis=");
        buffer.append(this.cacheTimeoutMillis);
        if (this.providerURL != null) {
            buffer.append(", providerURL='");
            buffer.append(this.providerURL);
            buffer.append('\'');
        }
        buffer.append(')');
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AddressSelectionMode {
        FAILOVER,
        RANDOM,
        ROUND_ROBIN;

    }
}

