/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.definition.adapter;

import java.util.Collections;
import java.util.LinkedHashSet;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.AbstractMorphAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.HasInheritance;
import org.kie.workbench.common.stunner.core.definition.clone.CloneManager;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.definition.morph.MorphProperty;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

public abstract class BindableMorphAdapter<S>
extends AbstractMorphAdapter<S> {
    private final CloneManager cloneManager;

    public BindableMorphAdapter(DefinitionUtils definitionUtils, FactoryManager factoryManager, CloneManager cloneManager) {
        super(definitionUtils, factoryManager);
        this.cloneManager = cloneManager;
    }

    @Override
    protected <T> T doMerge(S source, MorphDefinition morphDefinition, T result) {
        return (T)this.cloneManager.clone(source, result, morphDefinition.getPolicy());
    }

    @Override
    public <T> Iterable<MorphProperty> getMorphProperties(T definition) {
        return this.getMorphPropertiesForType(definition.getClass());
    }

    @Override
    public <T> Iterable<MorphDefinition> getMorphDefinitions(T definition) {
        return this.getMorphDefinitionsForType(definition.getClass());
    }

    public Iterable<MorphDefinition> getMorphDefinitionsForType(Class<?> type) {
        String dId = this.getDefinitionId(type);
        String baseId = this.getBaseDefinitionId(type);
        return super.getMorphDefinitions(dId, baseId);
    }

    public <T> Iterable<MorphProperty> getMorphPropertiesForType(Class<?> type) {
        String dId = this.getDefinitionId(type);
        String baseId = this.getBaseDefinitionId(type);
        return super.getMorphProperties(dId, baseId);
    }

    public <T> Iterable<String> getTargetsForType(Class<?> type) {
        String dId = this.getDefinitionId(type);
        String baseId = this.getBaseDefinitionId(type);
        return this.getTargets(type, dId, baseId);
    }

    @Override
    protected Iterable<String> getTargets(Class<?> type, String definitionId, String baseId) {
        Iterable<String> superTargets = super.getTargets(type, definitionId, baseId);
        if (null != superTargets && superTargets.iterator().hasNext()) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (String s : superTargets) {
                String[] types = this.getTypes(type, s);
                if (null != types && types.length > 0) {
                    Collections.addAll(result, types);
                    continue;
                }
                result.add(s);
            }
            return result;
        }
        return null;
    }

    protected String[] getTypes(Class<?> adapterType, String baseType) {
        DefinitionAdapter definitionAdapter = this.getDefinitionManager().adapters().registry().getDefinitionAdapter(adapterType);
        if (definitionAdapter instanceof HasInheritance) {
            return ((HasInheritance)definitionAdapter).getTypes(baseType);
        }
        return null;
    }

    protected String getBaseDefinitionId(Class<?> type) {
        DefinitionAdapter definitionAdapter = this.getDefinitionManager().adapters().registry().getDefinitionAdapter(type);
        if (definitionAdapter instanceof HasInheritance) {
            return ((HasInheritance)definitionAdapter).getBaseType(type);
        }
        return null;
    }

    protected String getDefinitionId(Class<?> type) {
        return BindableAdapterUtils.getDefinitionId(type);
    }
}

