/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.registry.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.api.AbstractDefinitionManager;
import org.kie.workbench.common.stunner.core.definition.adapter.Adapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionSetAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionSetRuleAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.MorphAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.PriorityAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.PropertyAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.PropertySetAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.exception.AdapterNotFoundException;
import org.kie.workbench.common.stunner.core.registry.DynamicRegistry;
import org.kie.workbench.common.stunner.core.registry.definition.AdapterRegistry;

public class AdapterRegistryImpl
implements AdapterRegistry,
DynamicRegistry<Adapter> {
    private static Logger LOGGER = Logger.getLogger(AbstractDefinitionManager.class.getName());
    private final List<DefinitionSetAdapter> definitionSetAdapters = new LinkedList<DefinitionSetAdapter>();
    private final List<DefinitionSetRuleAdapter> definitionSetRuleAdapters = new LinkedList<DefinitionSetRuleAdapter>();
    private final List<DefinitionAdapter> definitionAdapters = new LinkedList<DefinitionAdapter>();
    private final List<PropertySetAdapter> propertySetAdapters = new ArrayList<PropertySetAdapter>();
    private final List<PropertyAdapter> propertyAdapters = new LinkedList<PropertyAdapter>();
    private final List<MorphAdapter> morphAdapters = new LinkedList<MorphAdapter>();

    public <T> DefinitionSetAdapter<T> getDefinitionSetAdapter(Class<?> type) {
        for (DefinitionSetAdapter adapter : this.definitionSetAdapters) {
            if (!adapter.accepts(type)) continue;
            return adapter;
        }
        return (DefinitionSetAdapter)this.nullHandling(DefinitionSetAdapter.class, type);
    }

    public <T> DefinitionSetRuleAdapter<T> getDefinitionSetRuleAdapter(Class<?> type) {
        for (DefinitionSetRuleAdapter adapter : this.definitionSetRuleAdapters) {
            if (!adapter.accepts(type)) continue;
            return adapter;
        }
        return (DefinitionSetRuleAdapter)this.nullHandling(DefinitionSetRuleAdapter.class, type);
    }

    public <T> DefinitionAdapter<T> getDefinitionAdapter(Class<?> type) {
        for (DefinitionAdapter adapter : this.definitionAdapters) {
            if (!adapter.accepts(type)) continue;
            return adapter;
        }
        return (DefinitionAdapter)this.nullHandling(DefinitionAdapter.class, type);
    }

    public <T> PropertySetAdapter<T> getPropertySetAdapter(Class<?> type) {
        for (PropertySetAdapter adapter : this.propertySetAdapters) {
            if (!adapter.accepts(type)) continue;
            return adapter;
        }
        return (PropertySetAdapter)this.nullHandling(PropertySetAdapter.class, type);
    }

    public <T> PropertyAdapter<T, ?> getPropertyAdapter(Class<?> type) {
        for (PropertyAdapter adapter : this.propertyAdapters) {
            if (!adapter.accepts(type)) continue;
            return adapter;
        }
        return (PropertyAdapter)this.nullHandling(PropertyAdapter.class, type);
    }

    public <T> MorphAdapter<T> getMorphAdapter(Class<?> type) {
        for (MorphAdapter adapter : this.morphAdapters) {
            if (!adapter.accepts(type)) continue;
            return adapter;
        }
        return null;
    }

    public void register(Adapter item) {
        boolean registered = false;
        if (item instanceof DefinitionSetAdapter) {
            this.definitionSetAdapters.add((DefinitionSetAdapter)item);
            AdapterRegistryImpl.sortAdapters(this.definitionSetAdapters);
            registered = true;
        } else if (item instanceof DefinitionSetRuleAdapter) {
            this.definitionSetRuleAdapters.add((DefinitionSetRuleAdapter)item);
            AdapterRegistryImpl.sortAdapters(this.definitionSetRuleAdapters);
            registered = true;
        } else if (item instanceof DefinitionAdapter) {
            this.definitionAdapters.add((DefinitionAdapter)item);
            AdapterRegistryImpl.sortAdapters(this.definitionAdapters);
            registered = true;
        } else if (item instanceof PropertySetAdapter) {
            this.propertySetAdapters.add((PropertySetAdapter)item);
            AdapterRegistryImpl.sortAdapters(this.propertySetAdapters);
            registered = true;
        } else if (item instanceof PropertyAdapter) {
            this.propertyAdapters.add((PropertyAdapter)item);
            AdapterRegistryImpl.sortAdapters(this.propertyAdapters);
            registered = true;
        } else if (item instanceof MorphAdapter) {
            this.morphAdapters.add((MorphAdapter)item);
            registered = true;
        }
        if (!registered) {
            String em = "Cannot register Adapter for type [" + item.getClass().getName() + "]. Type not supported.";
            LOGGER.severe(em);
            throw new IllegalArgumentException(em);
        }
    }

    public boolean contains(Adapter item) {
        if (item instanceof DefinitionSetAdapter) {
            return this.definitionSetAdapters.contains(item);
        }
        if (item instanceof DefinitionSetRuleAdapter) {
            return this.definitionSetRuleAdapters.contains(item);
        }
        if (item instanceof DefinitionAdapter) {
            return this.definitionAdapters.contains(item);
        }
        if (item instanceof PropertySetAdapter) {
            return this.propertySetAdapters.contains(item);
        }
        if (item instanceof PropertyAdapter) {
            return this.propertyAdapters.contains(item);
        }
        if (item instanceof MorphAdapter) {
            return this.morphAdapters.contains(item);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.definitionSetAdapters.isEmpty() && this.definitionSetRuleAdapters.isEmpty() && this.definitionAdapters.isEmpty() && this.propertySetAdapters.isEmpty() && this.propertyAdapters.isEmpty() && this.morphAdapters.isEmpty();
    }

    public boolean remove(Adapter item) {
        if (item instanceof DefinitionSetAdapter) {
            return this.definitionSetAdapters.remove(item);
        }
        if (item instanceof DefinitionSetRuleAdapter) {
            return this.definitionSetRuleAdapters.remove(item);
        }
        if (item instanceof DefinitionAdapter) {
            return this.definitionAdapters.remove(item);
        }
        if (item instanceof PropertySetAdapter) {
            return this.propertySetAdapters.remove(item);
        }
        if (item instanceof PropertyAdapter) {
            return this.propertyAdapters.remove(item);
        }
        if (item instanceof MorphAdapter) {
            return this.morphAdapters.remove(item);
        }
        return false;
    }

    private static <T extends PriorityAdapter> void sortAdapters(List<T> adapters) {
        Collections.sort(adapters, Comparator.comparingInt(PriorityAdapter::getPriority));
    }

    private <T> T nullHandling(Class<? extends Adapter> adapterType, Class<?> type) {
        AdapterNotFoundException exception = new AdapterNotFoundException(adapterType, type);
        LOGGER.severe(exception.getMessage());
        throw exception;
    }
}

