/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule.context.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.rule.context.GraphEvaluationState;
import org.kie.workbench.common.stunner.core.rule.context.NodeContainmentContext;
import org.kie.workbench.common.stunner.core.rule.context.impl.AbstractGraphEvaluationState;

public class StatefulGraphEvaluationState
extends AbstractGraphEvaluationState {
    private final StatefulCardinalityState cardinality;
    private final StatefulConnectorCardinalityState connectorCardinality;
    private final StatefulConnectionState connection;
    private final StatefulContainmentState containment;
    private final StatefulDockingState docking;

    public StatefulGraphEvaluationState(Graph<?, ? extends Node> graph) {
        super(graph);
        this.cardinality = new StatefulCardinalityState();
        this.connectorCardinality = new StatefulConnectorCardinalityState();
        this.connection = new StatefulConnectionState();
        this.containment = new StatefulContainmentState();
        this.docking = new StatefulDockingState();
    }

    StatefulGraphEvaluationState(Graph<?, ? extends Node> graph, StatefulCardinalityState cardinality, StatefulConnectorCardinalityState connectorCardinality, StatefulConnectionState connection, StatefulContainmentState containment, StatefulDockingState docking) {
        super(graph);
        this.cardinality = cardinality;
        this.connectorCardinality = connectorCardinality;
        this.connection = connection;
        this.containment = containment;
        this.docking = docking;
    }

    public StatefulCardinalityState getCardinalityState() {
        return this.cardinality;
    }

    public StatefulConnectorCardinalityState getConnectorCardinalityState() {
        return this.connectorCardinality;
    }

    public StatefulConnectionState getConnectionState() {
        return this.connection;
    }

    public StatefulContainmentState getContainmentState() {
        return this.containment;
    }

    public StatefulDockingState getDockingState() {
        return this.docking;
    }

    public void clear() {
        this.cardinality.clear();
        this.connectorCardinality.clear();
        this.connection.clear();
        this.containment.clear();
        this.docking.clear();
    }

    private static Collection<Edge> getOrPut(Map<Node, Collection<Edge>> edges, Collection<Edge> value, Node<? extends View<?>, Edge> node) {
        Collection<Edge> result = edges.get(node);
        if (null == result) {
            result = new ArrayList<Edge>();
            if (null != value) {
                result.addAll(value.stream().filter(e -> e.getContent() instanceof Definition).collect(Collectors.toList()));
            }
            edges.put(node, result);
        }
        return result;
    }

    public static class Value<V> {
        private final V value;

        private Value(V value) {
            this.value = value;
        }

        public V get() {
            return this.value;
        }
    }

    public static class StateMap<T, V> {
        private final Map<T, Value<V>> state;
        private final Function<T, V> defaultValueSupplier;

        public StateMap(Function<T, V> defaultValueSupplier) {
            this.defaultValueSupplier = defaultValueSupplier;
            this.state = new HashMap<T, Value<V>>();
        }

        public void set(T key, V value) {
            this.state.put(key, new Value(value));
        }

        public V get(T key) {
            Value<V> value = this.state.get(key);
            if (null == value) {
                return this.defaultValueSupplier.apply(key);
            }
            return value.get();
        }

        public boolean isEmpty() {
            return this.state.isEmpty();
        }

        public void clear() {
            this.state.clear();
        }
    }

    public static class StatefulDockingState
    implements GraphEvaluationState.DockingState {
        private final StateMap<Node, Element> docks = new StateMap<Node, Element>(AbstractGraphEvaluationState.dockParentSupplier::apply);

        void clear() {
            this.docks.clear();
        }

        StatefulDockingState setDockedTo(Node node, Element parent) {
            this.docks.set(node, parent);
            return this;
        }

        StateMap<Node, Element> getDockedElements() {
            return this.docks;
        }

        public Element<? extends Definition<?>> getDockedTo(Node<? extends Definition<?>, ? extends Edge> node) {
            return this.docks.get(node);
        }
    }

    public static class StatefulContainmentState
    implements GraphEvaluationState.ContainmentState {
        private final StateMap<Node, Element> parents = new StateMap<Node, Element>(GraphUtils::getParent);

        void clear() {
            this.parents.clear();
        }

        StatefulContainmentState setParent(Node node, Element parent) {
            this.parents.set(node, parent);
            return this;
        }

        StateMap<Node, Element> getParents() {
            return this.parents;
        }

        public Element<? extends Definition<?>> getParent(Node<? extends Definition<?>, ? extends Edge> node) {
            Element parent = this.parents.get(node);
            return parent;
        }

        public static Element<? extends Definition<?>> getParent(NodeContainmentContext context, Node<? extends Definition<?>, ? extends Edge> node) {
            if (context.getCandidates().contains(node)) {
                return context.getParent();
            }
            return context.getState().getContainmentState().getParent(node);
        }
    }

    public static class StatefulConnectionState
    implements GraphEvaluationState.ConnectionState {
        private final StateMap<Edge, Node> sources = new StateMap<Edge, Node>(Edge::getSourceNode);
        private final StateMap<Edge, Node> targets = new StateMap<Edge, Node>(Edge::getTargetNode);

        void clear() {
            this.sources.clear();
            this.targets.clear();
        }

        StatefulConnectionState setSourceNode(Edge edge, Node node) {
            this.sources.set(edge, node);
            return this;
        }

        StatefulConnectionState setTargetNode(Edge edge, Node node) {
            this.targets.set(edge, node);
            return this;
        }

        public Node<? extends View<?>, ? extends Edge> getSource(Edge<? extends View<?>, ? extends Node> edge) {
            return this.sources.get(edge);
        }

        public Node<? extends View<?>, ? extends Edge> getTarget(Edge<? extends View<?>, ? extends Node> edge) {
            return this.targets.get(edge);
        }
    }

    public class StatefulConnectorCardinalityState
    implements GraphEvaluationState.ConnectorCardinalityState {
        private final Map<Node, Collection<Edge>> incoming = new HashMap<Node, Collection<Edge>>();
        private final Map<Node, Collection<Edge>> outgoing = new HashMap<Node, Collection<Edge>>();

        void clear() {
            this.incoming.clear();
            this.outgoing.clear();
        }

        void addIncoming(Node<? extends View<?>, Edge> node, Edge<? extends View<?>, Node> connector) {
            Collection<Edge> inEdges = this.getOrPutIncoming(node);
            inEdges.add(connector);
        }

        boolean deleteIncoming(Node<? extends View<?>, Edge> node, Edge<? extends View<?>, Node> connector) {
            Collection<Edge> inEdges = this.getOrPutIncoming(node);
            return inEdges.remove(connector);
        }

        void addOutgoing(Node<? extends View<?>, Edge> node, Edge<? extends View<?>, Node> connector) {
            Collection<Edge> outEdges = this.getOrPutOutgoing(node);
            outEdges.add(connector);
        }

        boolean deleteOutgoing(Node<? extends View<?>, Edge> node, Edge<? extends View<?>, Node> connector) {
            Collection<Edge> outEdges = this.getOrPutOutgoing(node);
            return outEdges.remove(connector);
        }

        Map<Node, Collection<Edge>> getIncoming() {
            return this.incoming;
        }

        Map<Node, Collection<Edge>> getOutgoing() {
            return this.outgoing;
        }

        public Collection<Edge<? extends View<?>, Node>> getIncoming(Node<? extends View<?>, Edge> node) {
            return AbstractGraphEvaluationState.unmodifiableCast(this.getOrPutIncoming(node));
        }

        public Collection<Edge<? extends View<?>, Node>> getOutgoing(Node<? extends View<?>, Edge> node) {
            return AbstractGraphEvaluationState.unmodifiableCast(this.getOrPutOutgoing(node));
        }

        private Collection<Edge> getOrPutIncoming(Node<? extends View<?>, Edge> node) {
            return StatefulGraphEvaluationState.getOrPut(this.incoming, node.getInEdges(), node);
        }

        private Collection<Edge> getOrPutOutgoing(Node<? extends View<?>, Edge> node) {
            return StatefulGraphEvaluationState.getOrPut(this.outgoing, node.getOutEdges(), node);
        }
    }

    public class StatefulCardinalityState
    implements GraphEvaluationState.CardinalityState {
        private final Collection<Element<? extends View<?>>> added = new HashSet();
        private final Collection<Element<? extends View<?>>> deleted = new HashSet();

        boolean add(Element<? extends View<?>> element) {
            return this.added.add(element);
        }

        boolean delete(Element<? extends View<?>> element) {
            return this.deleted.add(element);
        }

        void clear() {
            this.added.clear();
            this.deleted.clear();
        }

        public Iterable<Node> nodes() {
            Iterable nodes = StatefulGraphEvaluationState.this.getGraph().nodes();
            return StreamSupport.stream(nodes.spliterator(), false).filter(e -> !this.getDeletedElements().contains(e)).collect(Collectors.collectingAndThen(Collectors.toList(), this::appendAddedNodes));
        }

        private Collection<Node> appendAddedNodes(Collection<Node> nodes) {
            this.getAddedElements().stream().filter(e -> Objects.nonNull(e.asNode())).forEach(node -> nodes.add((Node)node));
            return nodes;
        }

        Collection<Element<? extends View<?>>> getAddedElements() {
            return Collections.unmodifiableCollection(this.added);
        }

        Collection<Element<? extends View<?>>> getDeletedElements() {
            return Collections.unmodifiableCollection(this.deleted);
        }
    }
}

