/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.repositories.changerequest.portable;

import java.util.Objects;
import org.guvnor.structure.repositories.changerequest.portable.ChangeType;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.backend.vfs.Path;

@Portable
public class ChangeRequestDiff {
    private Path oldFilePath;
    private Path newFilePath;
    private ChangeType changeType;
    private Integer addedLinesCount;
    private Integer deletedLinesCount;
    private String diffText;
    private Boolean conflict;

    public ChangeRequestDiff(@MapsTo(value="oldFilePath") Path oldFilePath, @MapsTo(value="newFilePath") Path newFilePath, @MapsTo(value="changeType") ChangeType changeType, @MapsTo(value="addedLinesCount") Integer addedLinesCount, @MapsTo(value="deletedLinesCount") Integer deletedLinesCount, @MapsTo(value="diffText") String diffText, @MapsTo(value="conflict") Boolean conflict) {
        this.oldFilePath = (Path)PortablePreconditions.checkNotNull((String)"oldFilePath", (Object)oldFilePath);
        this.newFilePath = (Path)PortablePreconditions.checkNotNull((String)"newFilePath", (Object)newFilePath);
        this.changeType = (ChangeType)((Object)PortablePreconditions.checkNotNull((String)"changeType", (Object)((Object)changeType)));
        this.addedLinesCount = (Integer)PortablePreconditions.checkNotNull((String)"addedLinesCount", (Object)addedLinesCount);
        this.deletedLinesCount = (Integer)PortablePreconditions.checkNotNull((String)"deletedLinesCount", (Object)deletedLinesCount);
        this.diffText = PortablePreconditions.checkNotEmpty((String)"diffText", (String)diffText);
        this.conflict = (Boolean)PortablePreconditions.checkNotNull((String)"conflict", (Object)conflict);
    }

    public Path getOldFilePath() {
        return this.oldFilePath;
    }

    public Path getNewFilePath() {
        return this.newFilePath;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public Integer getAddedLinesCount() {
        return this.addedLinesCount;
    }

    public Integer getDeletedLinesCount() {
        return this.deletedLinesCount;
    }

    public String getDiffText() {
        return this.diffText;
    }

    public Boolean isConflict() {
        return this.conflict;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeRequestDiff that = (ChangeRequestDiff)o;
        return this.oldFilePath.equals(that.oldFilePath) && this.newFilePath.equals(that.newFilePath) && this.changeType == that.changeType && this.addedLinesCount.equals(that.addedLinesCount) && this.deletedLinesCount.equals(that.deletedLinesCount) && this.diffText.equals(that.diffText) && this.conflict == that.conflict;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.oldFilePath, this.newFilePath, this.changeType, this.addedLinesCount, this.deletedLinesCount, this.diffText, this.conflict});
    }
}

