/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.project;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.AbstractModuleService;
import org.guvnor.common.services.project.backend.server.ModuleFinder;
import org.guvnor.common.services.project.backend.server.ResourceResolver;
import org.guvnor.common.services.project.builder.events.InvalidateDMOModuleCacheEvent;
import org.guvnor.common.services.project.events.NewModuleEvent;
import org.guvnor.common.services.project.events.NewPackageEvent;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.ModuleRepositoryResolver;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.project.KieModuleFactory;
import org.kie.workbench.common.services.backend.project.KieResourceResolver;
import org.kie.workbench.common.services.backend.project.ModuleSaver;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModulePackages;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

@Service
@ApplicationScoped
public class KieModuleServiceImpl
extends AbstractModuleService<KieModule>
implements KieModuleFactory,
KieModuleService {
    private ModuleSaver moduleSaver;
    private ModuleRepositoryResolver repositoryResolver;

    public KieModuleServiceImpl() {
    }

    @Inject
    public KieModuleServiceImpl(@Named(value="ioStrategy") IOService ioService, ModuleSaver moduleSaver, POMService pomService, RepositoryService repoService, Event<NewModuleEvent> newModuleEvent, Event<NewPackageEvent> newPackageEvent, Event<InvalidateDMOModuleCacheEvent> invalidateDMOCache, SessionInfo sessionInfo, CommentedOptionFactory commentedOptionFactory, ModuleFinder moduleFinder, KieResourceResolver resourceResolver, ModuleRepositoryResolver repositoryResolver) {
        super(ioService, pomService, repoService, newModuleEvent, newPackageEvent, invalidateDMOCache, sessionInfo, commentedOptionFactory, moduleFinder, (ResourceResolver)resourceResolver);
        this.moduleSaver = moduleSaver;
        this.repositoryResolver = repositoryResolver;
    }

    protected void setModuleSaver(ModuleSaver projectSaver) {
        this.moduleSaver = projectSaver;
    }

    public KieModule newModule(org.uberfire.backend.vfs.Path repositoryPath, POM pom) {
        return this.newModule(repositoryPath, pom, DeploymentMode.VALIDATED);
    }

    public KieModule newModule(org.uberfire.backend.vfs.Path repositoryPath, POM pom, DeploymentMode mode) {
        if (DeploymentMode.VALIDATED.equals((Object)mode)) {
            this.checkRepositories(pom);
        }
        return this.moduleSaver.save(repositoryPath, pom);
    }

    private void checkRepositories(POM pom) {
        Set repositories = this.repositoryResolver.getRepositoriesResolvingArtifact(pom.getGav(), new MavenRepositoryMetadata[0]);
        if (repositories.size() > 0) {
            throw new GAVAlreadyExistsException(pom.getGav(), repositories);
        }
    }

    public KieModulePackages resolveModulePackages(Module activeModule) {
        return new KieModulePackages(this.resolvePackages(activeModule), this.resolveDefaultWorkspacePackage(activeModule));
    }

    public KieModule simpleModuleInstance(Path nioModuleRootPath) {
        return (KieModule)this.resourceResolver.simpleModuleInstance(nioModuleRootPath);
    }

    public KieModule resolveModule(org.uberfire.backend.vfs.Path resource) {
        return (KieModule)this.resourceResolver.resolveModule(resource);
    }

    public KieModule resolveModule(org.uberfire.backend.vfs.Path resource, boolean loadPOM) {
        return (KieModule)this.resourceResolver.resolveModule(resource, loadPOM);
    }

    public Module resolveParentModule(org.uberfire.backend.vfs.Path resource) {
        return this.resourceResolver.resolveParentModule(resource);
    }

    public Module resolveToParentModule(org.uberfire.backend.vfs.Path resource) {
        return this.resourceResolver.resolveToParentModule(resource);
    }

    public Set<Package> resolvePackages(Module project) {
        return this.resourceResolver.resolvePackages(project);
    }

    public Set<Package> resolvePackages(Package pkg) {
        return this.resourceResolver.resolvePackages(pkg);
    }

    public Package resolveDefaultPackage(Module project) {
        return this.resourceResolver.resolveDefaultPackage(project);
    }

    public Package resolveDefaultWorkspacePackage(Module project) {
        return this.resourceResolver.resolveDefaultWorkspacePackage(project);
    }

    public org.uberfire.backend.vfs.Path resolveDefaultPath(Package pkg, String resourceType) {
        return this.resourceResolver.resolveDefaultPath(pkg, resourceType);
    }

    public Package resolveParentPackage(Package pkg) {
        return this.resourceResolver.resolveParentPackage(pkg);
    }

    public boolean isPom(org.uberfire.backend.vfs.Path resource) {
        return this.resourceResolver.isPom(resource);
    }

    public Package resolvePackage(org.uberfire.backend.vfs.Path resource) {
        return this.resourceResolver.resolvePackage(resource);
    }
}

