/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.HardlinkCopyDirectoryWrapper;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardRecoveryException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.LocalShardSnapshot;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.Repository;

final class StoreRecovery {
    private final Logger logger;
    private final ShardId shardId;

    StoreRecovery(ShardId shardId, Logger logger) {
        this.logger = logger;
        this.shardId = shardId;
    }

    boolean recoverFromStore(IndexShard indexShard) {
        if (this.canRecover(indexShard)) {
            RecoverySource.Type recoveryType = indexShard.recoveryState().getRecoverySource().getType();
            assert (recoveryType == RecoverySource.Type.EMPTY_STORE || recoveryType == RecoverySource.Type.EXISTING_STORE) : "expected store recovery type but was: " + (Object)((Object)recoveryType);
            return this.executeRecovery(indexShard, () -> {
                this.logger.debug("starting recovery from store ...");
                this.internalRecoverFromStore(indexShard);
            });
        }
        return false;
    }

    boolean recoverFromLocalShards(BiConsumer<String, MappingMetaData> mappingUpdateConsumer, IndexShard indexShard, List<LocalShardSnapshot> shards) throws IOException {
        if (this.canRecover(indexShard)) {
            RecoverySource.Type recoveryType = indexShard.recoveryState().getRecoverySource().getType();
            assert (recoveryType == RecoverySource.Type.LOCAL_SHARDS) : "expected local shards recovery type: " + (Object)((Object)recoveryType);
            if (shards.isEmpty()) {
                throw new IllegalArgumentException("shards must not be empty");
            }
            Set indices = shards.stream().map(s -> s.getIndex()).collect(Collectors.toSet());
            if (indices.size() > 1) {
                throw new IllegalArgumentException("can't add shards from more than one index");
            }
            IndexMetaData indexMetaData = shards.get(0).getIndexMetaData();
            for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : indexMetaData.getMappings()) {
                mappingUpdateConsumer.accept((String)objectObjectCursor.key, (MappingMetaData)objectObjectCursor.value);
            }
            indexShard.mapperService().merge(indexMetaData, MapperService.MergeReason.MAPPING_RECOVERY, true);
            return this.executeRecovery(indexShard, () -> {
                this.logger.debug("starting recovery from local shards {}", (Object)shards);
                try {
                    Directory directory = indexShard.store().directory();
                    this.addIndices(indexShard.recoveryState().getIndex(), directory, shards.stream().map(s -> s.getSnapshotDirectory()).collect(Collectors.toList()).toArray(new Directory[shards.size()]));
                    this.internalRecoverFromStore(indexShard);
                    indexShard.getEngine().forceMerge(false, -1, false, false, false);
                }
                catch (IOException ex) {
                    throw new IndexShardRecoveryException(indexShard.shardId(), "failed to recover from local shards", ex);
                }
            });
        }
        return false;
    }

    void addIndices(RecoveryState.Index indexRecoveryStats, Directory target, Directory ... sources) throws IOException {
        target = new HardlinkCopyDirectoryWrapper(target);
        try (IndexWriter writer = new IndexWriter((Directory)new StatsDirectoryWrapper(target, indexRecoveryStats), new IndexWriterConfig(null).setCommitOnClose(false).setMergePolicy(NoMergePolicy.INSTANCE).setOpenMode(IndexWriterConfig.OpenMode.CREATE));){
            writer.addIndexes(sources);
            writer.commit();
        }
    }

    boolean recoverFromRepository(IndexShard indexShard, Repository repository) {
        if (this.canRecover(indexShard)) {
            RecoverySource.Type recoveryType = indexShard.recoveryState().getRecoverySource().getType();
            assert (recoveryType == RecoverySource.Type.SNAPSHOT) : "expected snapshot recovery type: " + (Object)((Object)recoveryType);
            RecoverySource.SnapshotRecoverySource recoverySource = (RecoverySource.SnapshotRecoverySource)indexShard.recoveryState().getRecoverySource();
            return this.executeRecovery(indexShard, () -> {
                this.logger.debug("restoring from {} ...", (Object)indexShard.recoveryState().getRecoverySource());
                this.restore(indexShard, repository, recoverySource);
            });
        }
        return false;
    }

    private boolean canRecover(IndexShard indexShard) {
        if (indexShard.state() == IndexShardState.CLOSED) {
            return false;
        }
        if (!indexShard.routingEntry().primary()) {
            throw new IndexShardRecoveryException(this.shardId, "Trying to recover when the shard is in backup state", null);
        }
        return true;
    }

    private boolean executeRecovery(IndexShard indexShard, Runnable recoveryRunnable) throws IndexShardRecoveryException {
        try {
            recoveryRunnable.run();
            IndexShardState shardState = indexShard.state();
            RecoveryState recoveryState = indexShard.recoveryState();
            assert (shardState != IndexShardState.CREATED && shardState != IndexShardState.RECOVERING) : "recovery process of " + this.shardId + " didn't get to post_recovery. shardState [" + (Object)((Object)shardState) + "]";
            if (this.logger.isTraceEnabled()) {
                RecoveryState.Index index = recoveryState.getIndex();
                StringBuilder sb = new StringBuilder();
                sb.append("    index    : files           [").append(index.totalFileCount()).append("] with total_size [").append(new ByteSizeValue(index.totalBytes())).append("], took[").append(TimeValue.timeValueMillis(index.time())).append("]\n");
                sb.append("             : recovered_files [").append(index.recoveredFileCount()).append("] with total_size [").append(new ByteSizeValue(index.recoveredBytes())).append("]\n");
                sb.append("             : reusing_files   [").append(index.reusedFileCount()).append("] with total_size [").append(new ByteSizeValue(index.reusedBytes())).append("]\n");
                sb.append("    verify_index    : took [").append(TimeValue.timeValueMillis(recoveryState.getVerifyIndex().time())).append("], check_index [").append(TimeValue.timeValueMillis(recoveryState.getVerifyIndex().checkIndexTime())).append("]\n");
                sb.append("    translog : number_of_operations [").append(recoveryState.getTranslog().recoveredOperations()).append("], took [").append(TimeValue.timeValueMillis(recoveryState.getTranslog().time())).append("]");
                this.logger.trace("recovery completed from [shard_store], took [{}]\n{}", (Object)TimeValue.timeValueMillis(recoveryState.getTimer().time()), (Object)sb);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("recovery completed from [shard_store], took [{}]", (Object)TimeValue.timeValueMillis(recoveryState.getTimer().time()));
            }
            return true;
        }
        catch (IndexShardRecoveryException e) {
            if (indexShard.state() == IndexShardState.CLOSED) {
                return false;
            }
            if (e.getCause() instanceof IndexShardClosedException || e.getCause() instanceof IndexShardNotStartedException) {
                return false;
            }
            throw e;
        }
        catch (IndexShardClosedException | IndexShardNotStartedException e) {
        }
        catch (Exception e) {
            if (indexShard.state() == IndexShardState.CLOSED) {
                return false;
            }
            throw new IndexShardRecoveryException(this.shardId, "failed recovery", e);
        }
        return false;
    }

    private void internalRecoverFromStore(IndexShard indexShard) throws IndexShardRecoveryException {
        RecoveryState recoveryState = indexShard.recoveryState();
        boolean indexShouldExists = recoveryState.getRecoverySource().getType() != RecoverySource.Type.EMPTY_STORE;
        indexShard.prepareForIndexRecovery();
        long version = -1L;
        SegmentInfos si = null;
        Store store = indexShard.store();
        store.incRef();
        try {
            try {
                block20: {
                    store.failIfCorrupted();
                    try {
                        si = store.readLastCommittedSegmentsInfo();
                    }
                    catch (Exception e) {
                        String files = "_unknown_";
                        try {
                            files = Arrays.toString(store.directory().listAll());
                        }
                        catch (Exception inner) {
                            inner.addSuppressed(e);
                            files = files + " (failure=" + ExceptionsHelper.detailedMessage(inner) + ")";
                        }
                        if (!indexShouldExists) break block20;
                        throw new IndexShardRecoveryException(this.shardId, "shard allocated for local recovery (post api), should exist, but doesn't, current files: " + files, e);
                    }
                }
                if (si != null) {
                    if (indexShouldExists) {
                        version = si.getVersion();
                    } else {
                        this.logger.trace("cleaning existing shard, shouldn't exists");
                        Lucene.cleanLuceneIndex(store.directory());
                        si = null;
                    }
                }
            }
            catch (Exception e) {
                throw new IndexShardRecoveryException(this.shardId, "failed to fetch index version after copying it over", e);
            }
            recoveryState.getIndex().updateVersion(version);
            if (recoveryState.getRecoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) {
                assert (indexShouldExists);
                indexShard.skipTranslogRecovery(-1L);
            } else {
                try {
                    RecoveryState.Index index = recoveryState.getIndex();
                    if (si != null) {
                        this.addRecoveredFileDetails(si, store, index);
                    }
                }
                catch (IOException e) {
                    this.logger.debug("failed to list file details", (Throwable)e);
                }
                indexShard.performTranslogRecovery(indexShouldExists);
            }
            indexShard.finalizeRecovery();
            indexShard.postRecovery("post recovery from shard_store");
        }
        catch (IOException | EngineException e) {
            throw new IndexShardRecoveryException(this.shardId, "failed to recover from gateway", e);
        }
        finally {
            store.decRef();
        }
    }

    private void addRecoveredFileDetails(SegmentInfos si, Store store, RecoveryState.Index index) throws IOException {
        Directory directory = store.directory();
        for (String name : Lucene.files(si)) {
            long length = directory.fileLength(name);
            index.addFileDetail(name, length, true);
        }
    }

    private void restore(IndexShard indexShard, Repository repository, RecoverySource.SnapshotRecoverySource restoreSource) {
        RecoveryState.Translog translogState = indexShard.recoveryState().getTranslog();
        if (restoreSource == null) {
            throw new IndexShardRestoreFailedException(this.shardId, "empty restore source");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] restoring shard [{}]", (Object)restoreSource.snapshot(), (Object)this.shardId);
        }
        try {
            translogState.totalOperations(0);
            translogState.totalOperationsOnStart(0);
            indexShard.prepareForIndexRecovery();
            ShardId snapshotShardId = this.shardId;
            String indexName = restoreSource.index();
            if (!this.shardId.getIndexName().equals(indexName)) {
                snapshotShardId = new ShardId(indexName, "_na_", this.shardId.id());
            }
            IndexId indexId = repository.getRepositoryData().resolveIndexId(indexName);
            repository.restoreShard(indexShard, restoreSource.snapshot().getSnapshotId(), restoreSource.version(), indexId, snapshotShardId, indexShard.recoveryState());
            indexShard.skipTranslogRecovery(-1L);
            indexShard.finalizeRecovery();
            indexShard.postRecovery("restore done");
        }
        catch (Exception e) {
            throw new IndexShardRestoreFailedException(this.shardId, "restore failed", e);
        }
    }

    static final class StatsDirectoryWrapper
    extends FilterDirectory {
        private final RecoveryState.Index index;

        StatsDirectoryWrapper(Directory in, RecoveryState.Index indexRecoveryStats) {
            super(in);
            this.index = indexRecoveryStats;
        }

        public void copyFrom(Directory from, String src, final String dest, IOContext context) throws IOException {
            final long l = from.fileLength(src);
            final AtomicBoolean copies = new AtomicBoolean(false);
            this.in.copyFrom((Directory)new FilterDirectory(from){

                public IndexInput openInput(String name, IOContext context) throws IOException {
                    index.addFileDetail(dest, l, false);
                    copies.set(true);
                    final IndexInput input = this.in.openInput(name, context);
                    return new IndexInput("StatsDirectoryWrapper(" + input.toString() + ")"){

                        public void close() throws IOException {
                            input.close();
                        }

                        public long getFilePointer() {
                            throw new UnsupportedOperationException("only straight copies are supported");
                        }

                        public void seek(long pos) throws IOException {
                            throw new UnsupportedOperationException("seeks are not supported");
                        }

                        public long length() {
                            return input.length();
                        }

                        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
                            throw new UnsupportedOperationException("slices are not supported");
                        }

                        public byte readByte() throws IOException {
                            throw new UnsupportedOperationException("use a buffer if you wanna perform well");
                        }

                        public void readBytes(byte[] b, int offset, int len) throws IOException {
                            input.readBytes(b, offset, len);
                            index.addRecoveredBytesToFile(dest, len);
                        }
                    };
                }
            }, src, dest, context);
            if (!copies.get()) {
                this.index.addFileDetail(dest, l, true);
            } else {
                assert (this.index.getFileDetails(dest) != null) : "File [" + dest + "] has no file details";
                assert (this.index.getFileDetails(dest).recovered() == l) : this.index.getFileDetails(dest).toString();
            }
        }
    }
}

