/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.jbpm.server.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.bpmn2.UserTask;
import org.kie.workbench.common.forms.jbpm.model.authoring.task.TaskFormModel;
import org.kie.workbench.common.forms.jbpm.server.service.impl.Variable;
import org.kie.workbench.common.forms.model.ModelProperty;

public class TaskFormVariables {
    private String processId;
    private UserTask userTask;
    private String taskName;
    private Map<String, Variable> variables = new HashMap<String, Variable>();
    private boolean valid = true;
    private List<String> errors = new ArrayList<String>();

    public TaskFormVariables(UserTask userTask) {
        this.userTask = userTask;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void addVariable(Variable variable) {
        this.addVariable(Optional.empty(), variable);
    }

    public void addVariable(Optional<UserTask> userTask, Variable variable) {
        Variable existingVariable = this.variables.get(variable.getName());
        if (existingVariable != null) {
            if (!existingVariable.getType().equals(variable.getType())) {
                this.valid = false;
                StringBuffer message = new StringBuffer("Type conflict on task variable '").append(variable.getName()).append("': The variable type defined by task '").append(this.userTask.getName()).append("' (").append(existingVariable.getType()).append(") doesn't match the ");
                if (userTask.isPresent()) {
                    message.append("variable type defined by task '").append(userTask.get().getName()).append("' ");
                } else {
                    message.append("variable type received ");
                }
                message.append("(").append(variable.getType()).append(").");
                this.errors.add(message.toString());
            } else {
                if (variable.isInput()) {
                    existingVariable.setInput(variable.isInput());
                }
                if (variable.isOutput()) {
                    existingVariable.setOutput(variable.isOutput());
                }
            }
        } else {
            this.variables.put(variable.getName(), variable);
        }
    }

    public TaskFormModel toFormModel(Function<Variable, ModelProperty> converterFunction) {
        if (!this.isValid()) {
            return null;
        }
        List properties = this.variables.values().stream().sorted((o1, o2) -> this.sort((Variable)o1, (Variable)o2)).map(variable -> (ModelProperty)converterFunction.apply((Variable)variable)).filter(modelProperty -> modelProperty != null).collect(Collectors.toList());
        return new TaskFormModel(this.processId, this.taskName, properties);
    }

    public void merge(TaskFormVariables other) {
        other.variables.values().forEach(taskVariable -> this.addVariable(Optional.of(other.userTask), (Variable)taskVariable));
    }

    protected int sort(Variable variable1, Variable variable2) {
        boolean variable2OnlyInput;
        boolean variable1OnlyInput = variable1.isInput() && !variable1.isOutput();
        boolean bl = variable2OnlyInput = variable2.isInput() && !variable2.isOutput();
        if (variable1OnlyInput) {
            if (variable2OnlyInput) {
                return variable1.getName().compareToIgnoreCase(variable2.getName());
            }
            return -1;
        }
        if (variable2OnlyInput) {
            return 1;
        }
        return variable1.getName().compareToIgnoreCase(variable2.getName());
    }
}

