/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Optional;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Property;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.AssociationDeclaration;

public class OutputAssignmentReader {
    private final AssociationDeclaration associationDeclaration;

    public static OutputAssignmentReader fromAssociation(DataOutputAssociation out) {
        if (out.getTargetRef() instanceof Property) {
            String sourceName = ((DataOutput)out.getSourceRef().get(0)).getName();
            return new OutputAssignmentReader(sourceName, (Property)out.getTargetRef());
        }
        if (out.getAssignment() != null && !out.getAssignment().isEmpty() && out.getSourceRef() != null && !out.getSourceRef().isEmpty()) {
            DataOutput target = (DataOutput)out.getSourceRef().get(0);
            return new OutputAssignmentReader((Assignment)out.getAssignment().get(0), target.getName());
        }
        return null;
    }

    OutputAssignmentReader(String sourceName, Property target) {
        String propertyName = OutputAssignmentReader.getPropertyName(target);
        this.associationDeclaration = new AssociationDeclaration(AssociationDeclaration.Direction.Output, AssociationDeclaration.Type.SourceTarget, sourceName, propertyName);
    }

    OutputAssignmentReader(Assignment assignment, String targetName) {
        FormalExpression to = (FormalExpression)assignment.getTo();
        String body = to.getBody();
        String encodedBody = this.encode(body);
        this.associationDeclaration = new AssociationDeclaration(AssociationDeclaration.Direction.Output, AssociationDeclaration.Type.FromTo, targetName, encodedBody);
    }

    public AssociationDeclaration getAssociationDeclaration() {
        return this.associationDeclaration;
    }

    private static String getPropertyName(Property prop) {
        return prop.getName() == null ? prop.getId() : prop.getName();
    }

    private String encode(String body) {
        return Optional.ofNullable(body).filter(b -> !"null".equals(b)).map(b -> {
            try {
                return URLEncoder.encode(b, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(body, e);
            }
        }).orElse("");
    }
}

