/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.BusinessRuleTask;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.ScriptTask;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.ServiceTask;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.TextAnnotation;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.UserTask;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.AdHocSubProcessPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.AssociationPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.BoundaryEventPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.BusinessRuleTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.CallActivityPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.CatchEventPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.DefinitionsPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.FlowElementPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.GatewayPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.GenericServiceTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.LanePropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.MultipleInstanceSubProcessPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ProcessPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ScriptTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.SequenceFlowPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ServiceTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.SubProcessPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.TaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.TextAnnotationPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ThrowEventPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.UserTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;

public class PropertyReaderFactory {
    protected final BPMNDiagram diagram;
    protected final DefinitionResolver definitionResolver;

    public PropertyReaderFactory(DefinitionResolver definitionResolver) {
        this.diagram = definitionResolver.getDiagram();
        this.definitionResolver = definitionResolver;
    }

    public FlowElementPropertyReader of(FlowElement el) {
        return new FlowElementPropertyReader(el, this.diagram, this.definitionResolver.getShape(el.getId()), this.definitionResolver.getResolutionFactor());
    }

    public LanePropertyReader of(Lane el) {
        return new LanePropertyReader(el, this.diagram, this.definitionResolver.getShape(el.getId()), this.definitionResolver.getResolutionFactor());
    }

    public LanePropertyReader of(Lane el, Lane elParent) {
        return new LanePropertyReader(el, this.diagram, this.definitionResolver.getShape(el.getId()), this.definitionResolver.getShape(elParent.getId()), this.definitionResolver.getResolutionFactor());
    }

    public SequenceFlowPropertyReader of(SequenceFlow el) {
        return new SequenceFlowPropertyReader(el, this.diagram, this.definitionResolver);
    }

    public AssociationPropertyReader of(Association el) {
        return new AssociationPropertyReader(el, this.diagram, this.definitionResolver);
    }

    public GatewayPropertyReader of(Gateway el) {
        return new GatewayPropertyReader(el, this.diagram, this.definitionResolver.getShape(el.getId()), this.definitionResolver.getResolutionFactor());
    }

    public TaskPropertyReader of(Task el) {
        return new TaskPropertyReader(el, this.diagram, this.definitionResolver);
    }

    public UserTaskPropertyReader of(UserTask el) {
        return new UserTaskPropertyReader(el, this.diagram, this.definitionResolver);
    }

    public ScriptTaskPropertyReader of(ScriptTask el) {
        return new ScriptTaskPropertyReader(el, this.diagram, this.definitionResolver);
    }

    public GenericServiceTaskPropertyReader of(ServiceTask el) {
        return new GenericServiceTaskPropertyReader(el, this.diagram, this.definitionResolver);
    }

    public BusinessRuleTaskPropertyReader of(BusinessRuleTask el) {
        return new BusinessRuleTaskPropertyReader(el, this.diagram, this.definitionResolver);
    }

    public Optional<ServiceTaskPropertyReader> ofCustom(Task el) {
        String serviceTaskName = CustomAttribute.serviceTaskName.of((BaseElement)el).get();
        return this.definitionResolver.getWorkItemDefinitions().stream().filter(wid -> Objects.equals(wid.getName(), serviceTaskName)).findFirst().map(def -> new ServiceTaskPropertyReader(el, (WorkItemDefinition)def, this.diagram, this.definitionResolver));
    }

    public CallActivityPropertyReader of(CallActivity el) {
        return new CallActivityPropertyReader(el, this.diagram, this.definitionResolver);
    }

    public CatchEventPropertyReader of(CatchEvent el) {
        if (el instanceof BoundaryEvent) {
            return new BoundaryEventPropertyReader((BoundaryEvent)el, this.diagram, this.definitionResolver);
        }
        return new CatchEventPropertyReader(el, this.diagram, this.definitionResolver);
    }

    public ThrowEventPropertyReader of(ThrowEvent el) {
        return new ThrowEventPropertyReader(el, this.diagram, this.definitionResolver);
    }

    public SubProcessPropertyReader of(SubProcess el) {
        return new SubProcessPropertyReader(el, this.diagram, this.definitionResolver);
    }

    public AdHocSubProcessPropertyReader of(AdHocSubProcess el) {
        return new AdHocSubProcessPropertyReader(el, this.diagram, this.definitionResolver);
    }

    public MultipleInstanceSubProcessPropertyReader ofMultipleInstance(SubProcess el) {
        return new MultipleInstanceSubProcessPropertyReader(el, this.diagram, this.definitionResolver);
    }

    public ProcessPropertyReader of(Process el) {
        return new ProcessPropertyReader(el, this.diagram, this.definitionResolver.getShape(el.getId()), this.definitionResolver.getResolutionFactor());
    }

    public TextAnnotationPropertyReader of(TextAnnotation el) {
        return new TextAnnotationPropertyReader(el, this.diagram, this.definitionResolver.getShape(el.getId()), this.definitionResolver.getResolutionFactor());
    }

    public DefinitionsPropertyReader of(Definitions el) {
        return new DefinitionsPropertyReader(el, this.diagram, this.definitionResolver.getShape(el.getId()), this.definitionResolver.getResolutionFactor());
    }
}

