/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend.definition.adapter.bind;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.AbstractReflectAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindablePropertySetAdapter;
import org.kie.workbench.common.stunner.core.graph.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BackendBindablePropertySetAdapter<T>
extends AbstractReflectAdapter<T>
implements BindablePropertySetAdapter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BackendBindablePropertySetAdapter.class);
    private Map<Class, String> propertyNameFieldNames;
    private Map<Class, Set<String>> propertiesFieldNames;

    BackendBindablePropertySetAdapter() {
    }

    public void setBindings(Map<Class, String> propertyNameFieldNames, Map<Class, Set<String>> propertiesFieldNames) {
        this.propertyNameFieldNames = propertyNameFieldNames;
        this.propertiesFieldNames = propertiesFieldNames;
    }

    public String getId(T propertySet) {
        return BindableAdapterUtils.getPropertySetId(propertySet.getClass());
    }

    public String getName(T propertySet) {
        Class<?> type = propertySet.getClass();
        try {
            return (String)this.getFieldValue(propertySet, this.propertyNameFieldNames.get(type));
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining name for Property Set with id " + this.getId(propertySet));
            return null;
        }
    }

    public Set<?> getProperties(T propertySet) {
        Class<?> type = propertySet.getClass();
        Set<String> fields = this.propertiesFieldNames.get(type);
        try {
            return this.getFieldValues(propertySet, fields);
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining properties for Property Set with id " + this.getId(propertySet));
            return null;
        }
    }

    @Override
    public Optional<?> getProperty(T definition, String propertyName) {
        return Optional.ofNullable(this.propertiesFieldNames.get(definition.getClass())).orElse(Collections.emptySet()).stream().filter(name -> Objects.equals(name, propertyName)).findFirst().map(prop -> Exceptions.swallow(() -> this.getFieldValue(definition, (String)prop), null));
    }

    public boolean accepts(Class<?> type) {
        return null != this.propertyNameFieldNames && this.propertyNameFieldNames.containsKey(type);
    }
}

