/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.PodDNSConfig;
import io.fabric8.kubernetes.api.model.PodDNSConfigFluent;
import io.fabric8.kubernetes.api.model.PodDNSConfigOption;
import io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder;
import io.fabric8.kubernetes.api.model.PodDNSConfigOptionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PodDNSConfigFluentImpl<A extends PodDNSConfigFluent<A>>
extends BaseFluent<A>
implements PodDNSConfigFluent<A> {
    private List<String> nameservers;
    private List<PodDNSConfigOptionBuilder> options;
    private List<String> searches;

    public PodDNSConfigFluentImpl() {
    }

    public PodDNSConfigFluentImpl(PodDNSConfig instance) {
        this.withNameservers(instance.getNameservers());
        this.withOptions(instance.getOptions());
        this.withSearches(instance.getSearches());
    }

    @Override
    public A addToNameservers(int index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNameservers(int index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNameservers(String ... items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNameservers(Collection<String> items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNameservers(String ... items) {
        for (String item : items) {
            if (this.nameservers == null) continue;
            this.nameservers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNameservers(Collection<String> items) {
        for (String item : items) {
            if (this.nameservers == null) continue;
            this.nameservers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNameservers() {
        return this.nameservers;
    }

    @Override
    public String getNameserver(int index) {
        return this.nameservers.get(index);
    }

    @Override
    public String getFirstNameserver() {
        return this.nameservers.get(0);
    }

    @Override
    public String getLastNameserver() {
        return this.nameservers.get(this.nameservers.size() - 1);
    }

    @Override
    public String getMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNameservers(List<String> nameservers) {
        if (this.nameservers != null) {
            this._visitables.get("nameservers").removeAll(this.nameservers);
        }
        if (nameservers != null) {
            this.nameservers = new ArrayList<String>();
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        } else {
            this.nameservers = new ArrayList<String>();
        }
        return (A)this;
    }

    @Override
    public A withNameservers(String ... nameservers) {
        if (this.nameservers != null) {
            this.nameservers.clear();
        }
        if (nameservers != null) {
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNameservers() {
        return this.nameservers != null && !this.nameservers.isEmpty();
    }

    @Override
    public A addNewNameserver(String arg1) {
        return this.addToNameservers(new String(arg1));
    }

    @Override
    public A addNewNameserver(StringBuilder arg1) {
        return this.addToNameservers(new String(arg1));
    }

    @Override
    public A addNewNameserver(StringBuffer arg1) {
        return this.addToNameservers(new String(arg1));
    }

    @Override
    public A addToOptions(int index, PodDNSConfigOption item) {
        if (this.options == null) {
            this.options = new ArrayList<PodDNSConfigOptionBuilder>();
        }
        PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
        this._visitables.get("options").add(index >= 0 ? index : this._visitables.get("options").size(), builder);
        this.options.add(index >= 0 ? index : this.options.size(), builder);
        return (A)this;
    }

    @Override
    public A setToOptions(int index, PodDNSConfigOption item) {
        if (this.options == null) {
            this.options = new ArrayList<PodDNSConfigOptionBuilder>();
        }
        PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
        if (index < 0 || index >= this._visitables.get("options").size()) {
            this._visitables.get("options").add(builder);
        } else {
            this._visitables.get("options").set(index, builder);
        }
        if (index < 0 || index >= this.options.size()) {
            this.options.add(builder);
        } else {
            this.options.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToOptions(PodDNSConfigOption ... items) {
        if (this.options == null) {
            this.options = new ArrayList<PodDNSConfigOptionBuilder>();
        }
        for (PodDNSConfigOption item : items) {
            PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").add(builder);
            this.options.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToOptions(Collection<PodDNSConfigOption> items) {
        if (this.options == null) {
            this.options = new ArrayList<PodDNSConfigOptionBuilder>();
        }
        for (PodDNSConfigOption item : items) {
            PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").add(builder);
            this.options.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromOptions(PodDNSConfigOption ... items) {
        for (PodDNSConfigOption item : items) {
            PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").remove(builder);
            if (this.options == null) continue;
            this.options.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOptions(Collection<PodDNSConfigOption> items) {
        for (PodDNSConfigOption item : items) {
            PodDNSConfigOptionBuilder builder = new PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").remove(builder);
            if (this.options == null) continue;
            this.options.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PodDNSConfigOption> getOptions() {
        return PodDNSConfigFluentImpl.build(this.options);
    }

    @Override
    public List<PodDNSConfigOption> buildOptions() {
        return PodDNSConfigFluentImpl.build(this.options);
    }

    @Override
    public PodDNSConfigOption buildOption(int index) {
        return this.options.get(index).build();
    }

    @Override
    public PodDNSConfigOption buildFirstOption() {
        return this.options.get(0).build();
    }

    @Override
    public PodDNSConfigOption buildLastOption() {
        return this.options.get(this.options.size() - 1).build();
    }

    @Override
    public PodDNSConfigOption buildMatchingOption(Predicate<PodDNSConfigOptionBuilder> predicate) {
        for (PodDNSConfigOptionBuilder item : this.options) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOption(Predicate<PodDNSConfigOptionBuilder> predicate) {
        for (PodDNSConfigOptionBuilder item : this.options) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOptions(List<PodDNSConfigOption> options) {
        if (this.options != null) {
            this._visitables.get("options").removeAll(this.options);
        }
        if (options != null) {
            this.options = new ArrayList<PodDNSConfigOptionBuilder>();
            for (PodDNSConfigOption item : options) {
                this.addToOptions(item);
            }
        } else {
            this.options = new ArrayList<PodDNSConfigOptionBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withOptions(PodDNSConfigOption ... options) {
        if (this.options != null) {
            this.options.clear();
        }
        if (options != null) {
            for (PodDNSConfigOption item : options) {
                this.addToOptions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOptions() {
        return this.options != null && !this.options.isEmpty();
    }

    @Override
    public A addNewOption(String name, String value) {
        return this.addToOptions(new PodDNSConfigOption(name, value));
    }

    @Override
    public PodDNSConfigFluent.OptionsNested<A> addNewOption() {
        return new OptionsNestedImpl();
    }

    @Override
    public PodDNSConfigFluent.OptionsNested<A> addNewOptionLike(PodDNSConfigOption item) {
        return new OptionsNestedImpl(-1, item);
    }

    @Override
    public PodDNSConfigFluent.OptionsNested<A> setNewOptionLike(int index, PodDNSConfigOption item) {
        return new OptionsNestedImpl(index, item);
    }

    @Override
    public PodDNSConfigFluent.OptionsNested<A> editOption(int index) {
        if (this.options.size() <= index) {
            throw new RuntimeException("Can't edit options. Index exceeds size.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    @Override
    public PodDNSConfigFluent.OptionsNested<A> editFirstOption() {
        if (this.options.size() == 0) {
            throw new RuntimeException("Can't edit first options. The list is empty.");
        }
        return this.setNewOptionLike(0, this.buildOption(0));
    }

    @Override
    public PodDNSConfigFluent.OptionsNested<A> editLastOption() {
        int index = this.options.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last options. The list is empty.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    @Override
    public PodDNSConfigFluent.OptionsNested<A> editMatchingOption(Predicate<PodDNSConfigOptionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.options.size(); ++i) {
            if (!predicate.apply(this.options.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching options. No match found.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    @Override
    public A addToSearches(int index, String item) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        this.searches.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSearches(int index, String item) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        this.searches.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSearches(String ... items) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        for (String item : items) {
            this.searches.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSearches(Collection<String> items) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        for (String item : items) {
            this.searches.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSearches(String ... items) {
        for (String item : items) {
            if (this.searches == null) continue;
            this.searches.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSearches(Collection<String> items) {
        for (String item : items) {
            if (this.searches == null) continue;
            this.searches.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSearches() {
        return this.searches;
    }

    @Override
    public String getSearch(int index) {
        return this.searches.get(index);
    }

    @Override
    public String getFirstSearch() {
        return this.searches.get(0);
    }

    @Override
    public String getLastSearch() {
        return this.searches.get(this.searches.size() - 1);
    }

    @Override
    public String getMatchingSearch(Predicate<String> predicate) {
        for (String item : this.searches) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSearch(Predicate<String> predicate) {
        for (String item : this.searches) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSearches(List<String> searches) {
        if (this.searches != null) {
            this._visitables.get("searches").removeAll(this.searches);
        }
        if (searches != null) {
            this.searches = new ArrayList<String>();
            for (String item : searches) {
                this.addToSearches(item);
            }
        } else {
            this.searches = new ArrayList<String>();
        }
        return (A)this;
    }

    @Override
    public A withSearches(String ... searches) {
        if (this.searches != null) {
            this.searches.clear();
        }
        if (searches != null) {
            for (String item : searches) {
                this.addToSearches(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSearches() {
        return this.searches != null && !this.searches.isEmpty();
    }

    @Override
    public A addNewSearch(String arg1) {
        return this.addToSearches(new String(arg1));
    }

    @Override
    public A addNewSearch(StringBuilder arg1) {
        return this.addToSearches(new String(arg1));
    }

    @Override
    public A addNewSearch(StringBuffer arg1) {
        return this.addToSearches(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodDNSConfigFluentImpl that = (PodDNSConfigFluentImpl)o;
        if (this.nameservers != null ? !this.nameservers.equals(that.nameservers) : that.nameservers != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(that.options) : that.options != null) {
            return false;
        }
        return !(this.searches != null ? !this.searches.equals(that.searches) : that.searches != null);
    }

    public class OptionsNestedImpl<N>
    extends PodDNSConfigOptionFluentImpl<PodDNSConfigFluent.OptionsNested<N>>
    implements PodDNSConfigFluent.OptionsNested<N>,
    Nested<N> {
        private final PodDNSConfigOptionBuilder builder;
        private final int index;

        OptionsNestedImpl(int index, PodDNSConfigOption item) {
            this.index = index;
            this.builder = new PodDNSConfigOptionBuilder(this, item);
        }

        OptionsNestedImpl() {
            this.index = -1;
            this.builder = new PodDNSConfigOptionBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodDNSConfigFluentImpl.this.setToOptions(this.index, this.builder.build());
        }

        @Override
        public N endOption() {
            return this.and();
        }
    }
}

