/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ResultTest {
    @Mock
    private Object value;
    private final MarshallingMessage message = MarshallingMessage.builder().message("message").build();

    @Test
    public void success() {
        Result result = Result.success((Object)this.value, (MarshallingMessage[])new MarshallingMessage[]{this.message});
        this.assertResult(result, this.message, true, false, false, this.value);
    }

    @Test
    public void failure() {
        Result result = Result.failure((String)"Reason", (Object)this.value, (MarshallingMessage[])new MarshallingMessage[]{this.message});
        this.assertResult(result, this.message, false, true, false, this.value);
    }

    @Test
    public void failureWithNullValue() {
        Result result = Result.failure((String)"Reason", (MarshallingMessage[])new MarshallingMessage[]{this.message});
        this.assertResult(result, this.message, false, true, false, null);
    }

    @Test
    public void ignored() {
        Result result = Result.ignored((String)"Reason", (Object)this.value, (MarshallingMessage[])new MarshallingMessage[]{this.message});
        this.assertResult(result, this.message, false, false, true, this.value);
    }

    @Test
    public void ignoredWithNullValue() {
        Result result = Result.ignored((String)"Reason", (MarshallingMessage[])new MarshallingMessage[]{this.message});
        this.assertResult(result, this.message, false, false, true, null);
    }

    private void assertResult(Result result, MarshallingMessage message, boolean success, boolean failure, boolean ignored, Object value) {
        Assert.assertEquals((Object)value, (Object)result.value());
        Assert.assertEquals((Object)message, result.messages().get(0));
        Assert.assertEquals((long)result.messages().size(), (long)1L);
        Assert.assertEquals((Object)success, (Object)result.isSuccess());
        Assert.assertEquals((Object)failure, (Object)result.isFailure());
        Assert.assertEquals((Object)ignored, (Object)result.isIgnored());
    }
}

