/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.dd.dc.Bounds;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.BoundaryEventPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.CatchEventPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.GatewayPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ThrowEventPropertyReader;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FixedBoundsPropertyReadersTest {
    private static final double RESOLUTION_FACTOR = 1.0;
    private static final String CATCH_EVENT_ID = "ce";
    private static final String BOUNDARY_EVENT_ID = "be";
    private static final String THROW_EVENT_ID = "te";
    private static final String GATEWAY_EVENT_ID = "gw";
    @Mock
    private CatchEvent catchEvent;
    @Mock
    private BoundaryEvent boundaryEvent;
    @Mock
    private ThrowEvent throwEvent;
    @Mock
    private Gateway gateway;
    @Mock
    private BPMNDiagram diagram;
    @Mock
    private DefinitionResolver definitionResolver;
    @Mock
    private BPMNShape catchEventShape;
    @Mock
    private BPMNShape boundaryEventShape;
    @Mock
    private BPMNShape throwEventShape;
    @Mock
    private BPMNShape gatewayEventShape;
    private CatchEventPropertyReader catchEventPropertyReader;
    private BoundaryEventPropertyReader boundaryEventPropertyReader;
    private ThrowEventPropertyReader throwEventPropertyReader;
    private GatewayPropertyReader gatewayPropertyReader;

    @Before
    public void setup() {
        Mockito.when((Object)this.definitionResolver.getResolutionFactor()).thenReturn((Object)1.0);
        Mockito.when((Object)this.catchEvent.getId()).thenReturn((Object)CATCH_EVENT_ID);
        Mockito.when((Object)this.boundaryEvent.getId()).thenReturn((Object)BOUNDARY_EVENT_ID);
        Mockito.when((Object)this.throwEvent.getId()).thenReturn((Object)THROW_EVENT_ID);
        Mockito.when((Object)this.gateway.getId()).thenReturn((Object)GATEWAY_EVENT_ID);
        Mockito.when((Object)this.definitionResolver.getShape((String)Matchers.eq((Object)CATCH_EVENT_ID))).thenReturn((Object)this.catchEventShape);
        Mockito.when((Object)this.definitionResolver.getShape((String)Matchers.eq((Object)BOUNDARY_EVENT_ID))).thenReturn((Object)this.boundaryEventShape);
        Mockito.when((Object)this.definitionResolver.getShape((String)Matchers.eq((Object)THROW_EVENT_ID))).thenReturn((Object)this.throwEventShape);
        Mockito.when((Object)this.definitionResolver.getShape((String)Matchers.eq((Object)GATEWAY_EVENT_ID))).thenReturn((Object)this.gatewayEventShape);
        this.catchEventPropertyReader = new CatchEventPropertyReader(this.catchEvent, this.diagram, this.definitionResolver);
        this.boundaryEventPropertyReader = (BoundaryEventPropertyReader)Mockito.spy((Object)new BoundaryEventPropertyReader(this.boundaryEvent, this.diagram, this.definitionResolver));
        this.throwEventPropertyReader = new ThrowEventPropertyReader(this.throwEvent, this.diagram, this.definitionResolver);
        this.gatewayPropertyReader = new GatewayPropertyReader(this.gateway, this.diagram, this.gatewayEventShape, 1.0);
    }

    @Test
    public void testBounds() {
        Bounds catchEventShapeBounds = FixedBoundsPropertyReadersTest.mockBounds(1.0f, 2.0f, 123.2f, 322.3f);
        Mockito.when((Object)this.catchEventShape.getBounds()).thenReturn((Object)catchEventShapeBounds);
        Bounds throwEventShapeBounds = FixedBoundsPropertyReadersTest.mockBounds(5.0f, 6.0f, 2144.67f, 853.34f);
        Mockito.when((Object)this.throwEventShape.getBounds()).thenReturn((Object)throwEventShapeBounds);
        ((BoundaryEventPropertyReader)Mockito.doReturn((Object)Point2D.create((double)3.0, (double)4.0)).when((Object)this.boundaryEventPropertyReader)).getDockerInfo();
        Bounds gatewayEventShapeBounds = FixedBoundsPropertyReadersTest.mockBounds(7.0f, 8.0f, 4543.2f, 25.3f);
        Mockito.when((Object)this.gatewayEventShape.getBounds()).thenReturn((Object)gatewayEventShapeBounds);
        org.kie.workbench.common.stunner.core.graph.content.Bounds catchEventBounds = this.catchEventPropertyReader.getBounds();
        org.kie.workbench.common.stunner.core.graph.content.Bounds boundaryEventBounds = this.boundaryEventPropertyReader.getBounds();
        org.kie.workbench.common.stunner.core.graph.content.Bounds throwEventBounds = this.throwEventPropertyReader.getBounds();
        org.kie.workbench.common.stunner.core.graph.content.Bounds gatewayEventBounds = this.gatewayPropertyReader.getBounds();
        Assert.assertEquals((Object)org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)1.0, (double)2.0, (double)57.0, (double)58.0), (Object)catchEventBounds);
        Assert.assertEquals((Object)org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)3.0, (double)4.0, (double)59.0, (double)60.0), (Object)boundaryEventBounds);
        Assert.assertEquals((Object)org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)5.0, (double)6.0, (double)61.0, (double)62.0), (Object)throwEventBounds);
        Assert.assertEquals((Object)org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)7.0, (double)8.0, (double)63.0, (double)64.0), (Object)gatewayEventBounds);
    }

    private static Bounds mockBounds(float x, float y, float width, float height) {
        Bounds bounds = (Bounds)Mockito.mock(Bounds.class);
        Mockito.when((Object)Float.valueOf(bounds.getX())).thenReturn((Object)Float.valueOf(x));
        Mockito.when((Object)Float.valueOf(bounds.getY())).thenReturn((Object)Float.valueOf(y));
        Mockito.when((Object)Float.valueOf(bounds.getWidth())).thenReturn((Object)Float.valueOf(width));
        Mockito.when((Object)Float.valueOf(bounds.getHeight())).thenReturn((Object)Float.valueOf(height));
        return bounds;
    }
}

