/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.ParsedReassignmentsInfos;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.associations.AssociationType;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentValue;

public class ParsedReassignmentsInfosTest {
    @Test
    public void testReassignment() {
        String body = "[users:Forms,Reviewer,manager|groups:director,john]@[33y]";
        ReassignmentValue actual = ParsedReassignmentsInfos.of((String)AssociationType.NOT_COMPLETED_REASSIGN.getName(), (String)body);
        ReassignmentValue expected = new ReassignmentValue();
        expected.setType(AssociationType.NOT_COMPLETED_REASSIGN.getName());
        expected.setDuration("33y");
        expected.setGroups(new ArrayList<String>(Arrays.asList("director", "john")));
        expected.setUsers(new ArrayList<String>(Arrays.asList("Forms", "Reviewer", "manager")));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testReassignmentPartial() {
        String body = "[users:|groups:]@[33h]";
        ReassignmentValue actual = ParsedReassignmentsInfos.of((String)AssociationType.NOT_COMPLETED_REASSIGN.getName(), (String)body);
        ReassignmentValue expected = new ReassignmentValue();
        expected.setType(AssociationType.NOT_COMPLETED_REASSIGN.getName());
        expected.setDuration("33h");
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        Assert.assertEquals((Object)expected.toCDATAFormat(), (Object)actual.toCDATAFormat());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNotificationEmpty() {
        ReassignmentValue value = ParsedReassignmentsInfos.of((String)AssociationType.NOT_COMPLETED_REASSIGN.getName(), (String)"");
        ReassignmentValue valid = new ReassignmentValue();
        valid.setType(AssociationType.NOT_COMPLETED_REASSIGN.getName());
        Assert.assertEquals((Object)valid, (Object)value);
    }
}

