/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.ProcessType;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.ProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ProcessPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.DefaultImport;

public class ProcessPropertyReaderTest {
    private Definitions definitions;
    private DefinitionResolver definitionResolver;
    private Process process;
    private ProcessPropertyReader tested;

    @Before
    public void setUp() {
        this.definitions = Factories.bpmn2.createDefinitions();
        this.process = Factories.bpmn2.createProcess();
        this.definitions.getRootElements().add(this.process);
        BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
        bpmnDiagram.setPlane(Factories.di.createBPMNPlane());
        this.definitions.getDiagrams().add(bpmnDiagram);
        this.definitionResolver = new DefinitionResolver(this.definitions, Collections.emptyList());
        this.tested = new ProcessPropertyReader(this.process, this.definitionResolver.getDiagram(), this.definitionResolver.getShape(this.process.getId()), this.definitionResolver.getResolutionFactor());
    }

    @Test
    public void getDefaultImports() {
        String CLASS_NAME = "className";
        int QTY = 10;
        ArrayList<DefaultImport> defaultImports = new ArrayList<DefaultImport>();
        for (int i = 0; i < 10; ++i) {
            defaultImports.add(new DefaultImport("className" + i));
        }
        CustomElement.defaultImports.of((BaseElement)this.process).set(defaultImports);
        List result = this.tested.getDefaultImports();
        Assert.assertEquals((long)10L, (long)result.size());
        for (int i = 0; i < result.size(); ++i) {
            Assert.assertEquals((Object)("className" + i), (Object)((DefaultImport)result.get(i)).getClassName());
        }
    }

    @Test
    public void getProcessType() {
        ProcessPropertyWriter writer = new ProcessPropertyWriter(Factories.bpmn2.createProcess(), null);
        writer.setType(ProcessType.PRIVATE.getName());
        this.tested = new ProcessPropertyReader(writer.getProcess(), this.definitionResolver.getDiagram(), this.definitionResolver.getShape(this.process.getId()), this.definitionResolver.getResolutionFactor());
        Assert.assertEquals((Object)this.tested.getProcessType(), (Object)ProcessType.PRIVATE.getName());
        writer.setType(ProcessType.PUBLIC.getName());
        this.tested = new ProcessPropertyReader(writer.getProcess(), this.definitionResolver.getDiagram(), this.definitionResolver.getShape(this.process.getId()), this.definitionResolver.getResolutionFactor());
        Assert.assertEquals((Object)this.tested.getProcessType(), (Object)ProcessType.PUBLIC.getName());
        writer.setType(ProcessType.NONE.getName());
        this.tested = new ProcessPropertyReader(writer.getProcess(), this.definitionResolver.getDiagram(), this.definitionResolver.getShape(this.process.getId()), this.definitionResolver.getResolutionFactor());
        Assert.assertEquals((Object)this.tested.getProcessType(), (Object)ProcessType.NONE.getName());
    }
}

